/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.webcore.webservices;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeMap;
import javax.activation.DataHandler;
import net.omnis.webcore.webservices.SerialisedData;
import net.omnis.webcore.webservices.callservice;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.UnsignedInt;

public class serialise {
    public TreeMap<String, DataTypes> mTypeMappings = new TreeMap();
    private String mStubClassName;
    private String mLastError;
    private static int blockSize = 1024;
    private static final byte fftBoolean = 0;
    private static final byte fftByte = 1;
    private static final byte fftCharacter = 2;
    private static final byte fftDouble = 3;
    private static final byte fftInteger = 4;
    private static final byte fftString = 5;
    private static final byte fftDate = 6;
    private static final byte fftCalendar = 7;
    private static final byte fftTime = 8;
    private static final byte fftComplex = 9;
    private static final byte fftArray = 10;

    public serialise() {
        try {
            this.mTypeMappings.put("java.lang.Boolean", DataTypes.typeBoolean);
            this.mTypeMappings.put("java.lang.Byte", DataTypes.typeByte);
            this.mTypeMappings.put("javax.activation.DataHandler", DataTypes.typeByte);
            this.mTypeMappings.put("java.lang.Character", DataTypes.typeCharacter);
            this.mTypeMappings.put("java.lang.Double", DataTypes.typeDouble);
            this.mTypeMappings.put("java.lang.Integer", DataTypes.typeInteger);
            this.mTypeMappings.put("java.lang.String", DataTypes.typeCharacter);
            this.mTypeMappings.put("java.util.Date", DataTypes.typeDate);
            this.mTypeMappings.put("java.util.GregorianCalendar", DataTypes.typeDateTime);
            this.mTypeMappings.put("org.apache.axis2.databinding.types.Time", DataTypes.typeTime);
            this.mTypeMappings.put("java.lang.Long", DataTypes.typeLong);
            this.mTypeMappings.put("org.apache.axis2.databinding.types.Token", DataTypes.typeCharacter);
            this.mTypeMappings.put("java.math.BigDecimal", DataTypes.typeDouble);
            this.mTypeMappings.put("org.apache.axis2.databinding.types.UnsignedInt", DataTypes.typeLong);
        }
        catch (Exception e) {
            this.mLastError = e.toString();
        }
    }

    public serialise(String pClassName) {
        this();
        this.mStubClassName = pClassName;
    }

    private static byte[] toByteArray(Integer pInt) {
        return new byte[]{(byte)(pInt & 0xFF), (byte)(pInt >> 8 & 0xFF), (byte)(pInt >> 16 & 0xFF), (byte)(pInt >> 24 & 0xFF)};
    }

    private static byte[] toByteArray(Double pDouble) {
        long lLong = Double.doubleToRawLongBits(pDouble);
        return new byte[]{(byte)(lLong & 0xFFL), (byte)(lLong >> 8 & 0xFFL), (byte)(lLong >> 16 & 0xFFL), (byte)(lLong >> 24 & 0xFFL), (byte)(lLong >> 32 & 0xFFL), (byte)(lLong >> 40 & 0xFFL), (byte)(lLong >> 48 & 0xFFL), (byte)(lLong >> 56 & 0xFFL)};
    }

    private static byte[] toByteArray(Calendar pDate) {
        byte[] pReturn = new byte[9];
        pReturn[0] = (byte)(pDate.get(1) & 0xFF);
        pReturn[1] = (byte)(pDate.get(1) >> 8 & 0xFF);
        pReturn[2] = (byte)(pDate.get(2) & 0xFF);
        pReturn[3] = (byte)(pDate.get(5) & 0xFF);
        pReturn[4] = (byte)(pDate.get(10) & 0xFF);
        if (pDate.get(9) == 1) {
            pReturn[4] = (byte)(pReturn[4] + 12);
        }
        pReturn[5] = (byte)(pDate.get(12) & 0xFF);
        pReturn[6] = (byte)(pDate.get(13) & 0xFF);
        pReturn[7] = (byte)(pDate.get(14) & 0xFF);
        if (pDate.isSet(1) && pDate.isSet(2) && pDate.isSet(5)) {
            pReturn[8] = 1;
        }
        if (pDate.isSet(10) && pDate.isSet(12)) {
            pReturn[8] = (byte)(pReturn[8] | 2);
        }
        if (pDate.isSet(13)) {
            pReturn[8] = (byte)(pReturn[8] | 4);
        }
        if (pDate.isSet(14)) {
            pReturn[8] = (byte)(pReturn[8] | 8);
        }
        return pReturn;
    }

    private static Long byteArrayToLong(byte[] pByteArray) {
        long value = 0L;
        for (int x = 0; x < 8; ++x) {
            value <<= 8;
            value |= (long)(pByteArray[x] & 0xFF);
        }
        return value;
    }

    private static Integer byteArrayToInteger(byte[] pByteArray) {
        return 0xFF & pByteArray[0] | (0xFF & pByteArray[1]) << 8 | (0xFF & pByteArray[2]) << 16 | (0xFF & pByteArray[3]) << 24;
    }

    private static Double byteArrayToDouble(byte[] pByteArray) {
        return Double.longBitsToDouble((long)(pByteArray[0] & 0xFF) | (long)(pByteArray[1] & 0xFF) << 8 | (long)(pByteArray[2] & 0xFF) << 16 | (long)(pByteArray[3] & 0xFF) << 24 | (long)(pByteArray[4] & 0xFF) << 32 | (long)(pByteArray[5] & 0xFF) << 40 | (long)(pByteArray[6] & 0xFF) << 48 | (long)(pByteArray[7] & 0xFF) << 56);
    }

    private static Calendar byteArrayToDate(byte[] pByteArray) {
        Calendar lDate = Calendar.getInstance();
        lDate.clear();
        if ((pByteArray[8] & 1) == 1) {
            lDate.set(1, 0xFF & pByteArray[0] | (0xFF & pByteArray[1]) << 8);
            lDate.set(2, 0xFF & pByteArray[2]);
            lDate.set(5, 0xFF & pByteArray[3]);
        }
        if ((pByteArray[8] & 2) == 2) {
            lDate.set(10, 0xFF & pByteArray[4]);
            lDate.set(12, 0xFF & pByteArray[5]);
        }
        if ((pByteArray[8] & 4) == 4) {
            lDate.set(13, 0xFF & pByteArray[6]);
        }
        if ((pByteArray[8] & 8) == 8) {
            lDate.set(14, 0xFF & pByteArray[7]);
        }
        return lDate;
    }

    public byte[] serialiseThis(Object pAxisRtnObject, String pStubName) throws Exception {
        Method[] lGetterMeths;
        SerialisedData outBuffer = new SerialisedData();
        for (Method curGetterMethod : lGetterMeths = callservice.getMethods(pAxisRtnObject.getClass(), "get", true)) {
            Class<?> curClass;
            Object curVal = curGetterMethod.invoke(pAxisRtnObject, new Object[0]);
            if (curVal == null) {
                curVal = "NULL";
            }
            if ((curClass = curVal.getClass()).isArray()) {
                SerialisedData curArray = new SerialisedData();
                if (curClass.getComponentType().getName().startsWith(this.mStubClassName)) {
                    for (Object curObject : (Object[])curVal) {
                        byte[] arrayData = this.serialiseThis(curObject, pStubName);
                        curArray.addHeader(DataTypes.typeComplex, arrayData.length);
                        curArray.addData(arrayData);
                        curArray.addTrailer(curGetterMethod.getName().substring(3));
                    }
                } else if (curClass.getComponentType().isPrimitive()) {
                    curArray.addData(this.serialisePrimitiveArray(curVal, curGetterMethod.getName().substring(3)));
                } else {
                    for (Object curObject : (Object[])curVal) {
                        curArray.addData(this.serialiseElement(curObject, curGetterMethod.getName().substring(3)));
                    }
                }
                outBuffer.addHeader(DataTypes.typeArray, curArray.length());
                outBuffer.addData(curArray.toByteArray());
                outBuffer.addTrailer(curGetterMethod.getName().substring(3));
                continue;
            }
            if (curVal.getClass().getName().startsWith(pStubName)) {
                byte[] complexData = this.serialiseThis(curVal, pStubName);
                outBuffer.addHeader(DataTypes.typeComplex, complexData.length);
                outBuffer.addData(complexData);
                outBuffer.addTrailer(curGetterMethod.getName().substring(3));
                continue;
            }
            outBuffer.addData(this.serialiseElement(curVal, curGetterMethod.getName().substring(3)));
        }
        return outBuffer.toByteArray();
    }

    public byte[] serialisePrimitiveArray(Object pPrimArray, String pArrayName) {
        SerialisedData outBuffer;
        block6: {
            long[] longArray;
            block9: {
                float[] floatArray;
                block8: {
                    double[] doubleArray;
                    block7: {
                        boolean[] boolArray;
                        block5: {
                            int[] intArray;
                            outBuffer = new SerialisedData();
                            if (!(pPrimArray instanceof int[])) break block5;
                            for (int curInt : intArray = (int[])pPrimArray) {
                                outBuffer.addData(this.serialiseElement(curInt, pArrayName));
                            }
                            break block6;
                        }
                        if (!(pPrimArray instanceof boolean[])) break block7;
                        for (boolean curBool : boolArray = (boolean[])pPrimArray) {
                            outBuffer.addData(this.serialiseElement(curBool, pArrayName));
                        }
                        break block6;
                    }
                    if (!(pPrimArray instanceof double[])) break block8;
                    for (double curDouble : doubleArray = (double[])pPrimArray) {
                        outBuffer.addData(this.serialiseElement(curDouble, pArrayName));
                    }
                    break block6;
                }
                if (!(pPrimArray instanceof float[])) break block9;
                for (float curFloat : floatArray = (float[])pPrimArray) {
                    outBuffer.addData(this.serialiseElement(Float.valueOf(curFloat), pArrayName));
                }
                break block6;
            }
            if (!(pPrimArray instanceof long[])) break block6;
            for (long curLong : longArray = (long[])pPrimArray) {
                outBuffer.addData(this.serialiseElement(curLong, pArrayName));
            }
        }
        return outBuffer.toByteArray();
    }

    public static byte[] serialiseLong(Long lValue) {
        byte[] serialLong = new byte[8];
        int byteIndex = 0;
        for (int shiftVal = 0; shiftVal < 64; shiftVal = (int)((byte)(shiftVal + 8))) {
            serialLong[byteIndex++] = (byte)(lValue >> shiftVal & 0xFFL);
        }
        return serialLong;
    }

    public static byte[] serialiseInteger(Integer pInt) {
        byte[] serialInt = new byte[4];
        int byteIndex = 0;
        for (int shiftVal = 0; shiftVal < 32; shiftVal = (int)((byte)(shiftVal + 8))) {
            serialInt[byteIndex++] = (byte)(pInt >> shiftVal & 0xFF);
        }
        return serialInt;
    }

    private byte[] serialiseDouble(Double pDouble) {
        byte[] serialDouble = new byte[8];
        int byteIndex = 0;
        long rawVal = Double.doubleToRawLongBits(pDouble);
        for (int shiftVal = 0; shiftVal < 64; shiftVal = (int)((byte)(shiftVal + 8))) {
            serialDouble[byteIndex++] = (byte)(rawVal >> shiftVal & 0xFFL);
        }
        return serialDouble;
    }

    public byte[] serialiseElement(Object pElement, String pOptVarName) {
        byte[] payload = null;
        String clsName = pElement.getClass().getName();
        DataTypes elemType = this.mTypeMappings.get(clsName);
        SerialisedData outBuffer = new SerialisedData();
        try {
            switch (elemType) {
                case typeBoolean: {
                    payload = new byte[]{(Boolean)pElement != false ? (byte)1 : 0};
                    break;
                }
                case typeByte: {
                    InputStream dataStream = ((DataHandler)pElement).getInputStream();
                    int binLen = dataStream.available();
                    payload = new byte[binLen];
                    dataStream.read(payload, 0, binLen);
                    break;
                }
                case typeCharacter: {
                    if (pElement.getClass().equals(Token.class)) {
                        pElement = pElement.toString();
                    }
                    try {
                        payload = ((String)pElement).getBytes("UTF-8");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.mLastError = e.toString();
                        return null;
                    }
                }
                case typeDouble: {
                    if (pElement instanceof Double) {
                        payload = this.serialiseDouble((Double)pElement);
                        break;
                    }
                    if (!(pElement instanceof BigDecimal)) break;
                    payload = this.serialiseDouble(((BigDecimal)pElement).doubleValue());
                    break;
                }
                case typeInteger: {
                    payload = serialise.serialiseInteger((Integer)pElement);
                    break;
                }
                case typeLong: {
                    if (clsName.equals("org.apache.axis2.databinding.types.UnsignedInt")) {
                        payload = serialise.serialiseLong(((UnsignedInt)pElement).longValue());
                        break;
                    }
                    payload = serialise.serialiseLong((Long)pElement);
                    break;
                }
                case typeDate: {
                    Calendar dateObj = Calendar.getInstance();
                    dateObj.setTime((Date)pElement);
                    payload = serialise.toByteArray(dateObj);
                    payload[8] = 1;
                    break;
                }
                case typeDateTime: {
                    payload = serialise.toByteArray((Calendar)pElement);
                    break;
                }
                case typeTime: {
                    Calendar timeObj = ((Time)pElement).getAsCalendar();
                    payload = serialise.toByteArray(timeObj);
                    payload[8] = 14;
                }
            }
            if (payload != null) {
                outBuffer.addHeader(elemType, payload.length);
                outBuffer.addData(payload);
            }
            outBuffer.addTrailer(pOptVarName);
        }
        catch (Exception exc) {
            try {
                return this.serialiseElement(pElement.toString(), pOptVarName);
            }
            catch (Exception innerExc) {
                return this.serialiseElement("Serialisation Exception with type " + pOptVarName + ", " + exc.toString() + "reported.", clsName);
            }
        }
        return outBuffer.toByteArray();
    }

    public static Object[] deserialiseThis(byte[] pByteArray) throws Exception {
        ArrayList rtnList = serialise.deserialise(pByteArray);
        Object[] returnArray = new Object[rtnList.size()];
        rtnList.toArray(returnArray);
        return returnArray;
    }

    public static ArrayList deserialise(byte[] pByteArray) throws Exception {
        int dataLength;
        ArrayList<Object[]> unserialisedData = new ArrayList<Object[]>(0);
        Object objectToAdd = null;
        for (int i = 0; i < pByteArray.length; i += dataLength) {
            short dataType = pByteArray[i++];
            dataLength = pByteArray[i++] & 0xFF | (pByteArray[i++] & 0xFF) << 8 | (pByteArray[i++] & 0xFF) << 16 | (pByteArray[i++] & 0xFF) << 24;
            byte[] data = new byte[dataLength];
            System.arraycopy(pByteArray, i, data, 0, dataLength);
            switch (dataType) {
                case 25: {
                    String doubVal = new String(data, "UTF-8");
                    objectToAdd = new Double(doubVal);
                    break;
                }
                case 26: {
                    if (dataLength == 0) {
                        objectToAdd = new Integer(0);
                        break;
                    }
                    if (dataLength != 4) {
                        throw new Exception("Serialisation Exception : Integer type expected 4 bytes, got " + dataLength + " bytes");
                    }
                    objectToAdd = new Integer(serialise.byteArrayToInteger(data));
                    break;
                }
                case 64: {
                    if (dataLength == 0) {
                        objectToAdd = new Long(0L);
                        break;
                    }
                    if (dataLength != 8) {
                        throw new Exception("Serialisation Exception : Long type expected 8 bytes, got " + dataLength + " bytes");
                    }
                    objectToAdd = new Long(serialise.byteArrayToLong(data));
                    break;
                }
                case 21: {
                    objectToAdd = new String(data, "UTF-8");
                    break;
                }
                case 28: {
                    if (dataLength == 1) {
                        objectToAdd = new Byte(data[0]);
                        break;
                    }
                    objectToAdd = data;
                    break;
                }
                case 23: {
                    if (dataLength != 9) {
                        throw new Exception("Serialisation Exception : Date type expected 9 bytes, got " + dataLength + " bytes");
                    }
                    objectToAdd = serialise.byteArrayToDate(data);
                    break;
                }
                case 22: {
                    if (dataLength != 1) {
                        throw new Exception("Serialisation Exception : Boolean type expected 1 byte, got " + dataLength + " bytes");
                    }
                    if (data[0] == 2) {
                        objectToAdd = Boolean.TRUE;
                        break;
                    }
                    objectToAdd = Boolean.FALSE;
                    break;
                }
                case 29: {
                    objectToAdd = serialise.deserialise(data);
                    break;
                }
                case 36: {
                    objectToAdd = serialise.deserialiseThis(data);
                }
            }
            unserialisedData.add((Object[])objectToAdd);
        }
        unserialisedData.trimToSize();
        return unserialisedData;
    }

    public static enum DataTypes {
        typeBoolean,
        typeByte,
        typeCharacter,
        typeDouble,
        typeInteger,
        typeDate,
        typeTime,
        typeDateTime,
        typeComplex,
        typeArray,
        typeLong;

    }
}

