/*
 * Decompiled with CFR 0.152.
 */
package net.omnis.webcore.webservices;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import net.omnis.webcore.webservices.OmnisToJavaInputStream;
import net.omnis.webcore.webservices.callservice;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axis2.databinding.types.Time;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.UnsignedInt;

public class Deserialiser {
    private static final int fftDateTime = 1;
    private static final int fftTime = 2;
    private static final int fftNull = 20;
    private static final int fftCharacter = 21;
    private static final int fftBoolean = 22;
    private static final int fftDate = 23;
    private static final int fftNumber = 25;
    private static final int fftInteger = 26;
    private static final int fftBinary = 28;
    private static final int fftList = 29;
    private static final int fftRow = 36;
    private static final int fftLong = 64;

    public static Object InitInputObject(Class pClassToInit, OmnisToJavaInputStream omnisStream, boolean pCheckBuiltinClass) throws Exception {
        int curType;
        if (callservice.enableLogging) {
            callservice.log("InitInputObject: " + pClassToInit);
        }
        Object inputObject = null;
        boolean bUpdated = false;
        try {
            inputObject = pClassToInit.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            int curType2 = omnisStream.readByteAsInt();
            if (curType2 == 21) {
                int typeLen = omnisStream.readInt();
                byte[] typeData = new byte[typeLen];
                omnisStream.read(typeData, 0, typeLen);
                String enumKey = new String(typeData);
                inputObject = pClassToInit.getDeclaredField(enumKey).get(null);
            }
            if (inputObject == null) {
                throw new Exception("Unable to instantiate " + pClassToInit.getName() + " - could not find supported constructor and unable to instantiate as enum.");
            }
            return inputObject;
        }
        Method[] objectSetterMethods = callservice.getMethods(pClassToInit, "set", false);
        int minLen = callservice.DONT_SEND_EMPTY_PARAMS ? 1 : 0;
        for (Method curSetterMethod : objectSetterMethods) {
            Class<?> setterClass = curSetterMethod.getParameterTypes()[0];
            curType = omnisStream.readByteAsInt();
            int typeLen = omnisStream.readInt();
            if (typeLen < minLen) continue;
            byte[] typeData = new byte[typeLen];
            omnisStream.read(typeData, 0, typeLen);
            Object curObject = typeLen > 0 || setterClass.getName().equals("java.lang.String") ? Deserialiser.initObjectFromBinary(new OmnisToJavaInputStream(typeData), curType, setterClass) : null;
            if (curObject == null) continue;
            if (Deserialiser.checkTypes(curObject, setterClass)) {
                try {
                    curSetterMethod.invoke(inputObject, curObject);
                    if (callservice.enableLogging) {
                        callservice.log("    Set: " + curSetterMethod + ": " + curObject);
                    }
                    bUpdated = true;
                    continue;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof RuntimeException) || typeLen <= 0) continue;
                    throw e;
                }
            }
            if (setterClass.getCanonicalName().equals("java.util.Calendar") && curObject instanceof Date) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime((Date)curObject);
                curSetterMethod.invoke(inputObject, cal);
                if (callservice.enableLogging) {
                    callservice.log("    Set: " + curSetterMethod + ": " + cal);
                }
                bUpdated = true;
                continue;
            }
            if (setterClass.getCanonicalName().equals("java.math.BigDecimal")) {
                if (!(curObject instanceof Double)) continue;
                BigDecimal bd = new BigDecimal((Double)curObject, MathContext.DECIMAL64);
                curSetterMethod.invoke(inputObject, bd);
                if (callservice.enableLogging) {
                    callservice.log("    Set: " + curSetterMethod + ": " + bd);
                }
                bUpdated = true;
                continue;
            }
            if (setterClass.getCanonicalName().equals("org.apache.axis2.databinding.types.UnsignedInt")) {
                curSetterMethod.invoke(inputObject, new UnsignedInt((long)curType));
                bUpdated = true;
                continue;
            }
            if (bUpdated || (bUpdated = Deserialiser.checkWrapper(inputObject, curSetterMethod, curObject))) continue;
            throw new Exception("Type mismatch when processing input for " + curSetterMethod.getName() + ", expected '" + setterClass.getName() + "' got '" + curObject.getClass().getName() + "'");
        }
        omnisStream.mark(2);
        curType = omnisStream.readByteAsInt();
        if (objectSetterMethods.length == 0 && pCheckBuiltinClass && omnisStream.available() > 4 && curType == 21) {
            int len;
            if (pClassToInit.getName().equals("java.lang.String") && (len = omnisStream.readInt().intValue()) > 0) {
                byte[] bytes = new byte[len];
                omnisStream.read(bytes, 0, len);
                inputObject = new String(bytes);
                bUpdated = true;
            }
        } else {
            omnisStream.reset();
        }
        if (bUpdated) {
            return inputObject;
        }
        return null;
    }

    private static boolean checkWrapper(Object inputObject, Method setterMethod, Object curObject) {
        boolean bUpdated = false;
        Class<?> setterParam = setterMethod.getParameterTypes()[0];
        Method[] paramMethods = callservice.getMethods(setterParam, "set", false);
        if (paramMethods.length == 1) {
            boolean bTest;
            Method wrapperMethod = paramMethods[0];
            Class<?> wrapperParam = wrapperMethod.getParameterTypes()[0];
            boolean bl = bTest = wrapperParam == curObject.getClass();
            if (wrapperParam.isPrimitive() || wrapperParam.getName().equals("java.lang.String")) {
                try {
                    Object setterObj = setterParam.newInstance();
                    if (wrapperParam.equals(Integer.TYPE) && curObject instanceof Integer || wrapperParam.equals(String.class) && curObject instanceof String) {
                        wrapperMethod.invoke(setterObj, curObject);
                        setterMethod.invoke(inputObject, setterObj);
                        if (callservice.enableLogging) {
                            callservice.log("    Set: " + setterMethod + ": " + setterObj);
                        }
                        bUpdated = true;
                    }
                }
                catch (Throwable t) {
                    bUpdated = false;
                }
            }
        }
        return bUpdated;
    }

    private static boolean checkTypes(Object pObject, Class pClass) throws Exception {
        if (pClass.isPrimitive()) {
            if (pClass.equals(Integer.TYPE)) {
                return pObject instanceof Integer;
            }
            if (pClass.equals(Double.TYPE)) {
                return pObject instanceof Double;
            }
            if (pClass.equals(Boolean.TYPE)) {
                return pObject instanceof Boolean;
            }
            if (pClass.equals(Long.TYPE)) {
                return pObject instanceof Long;
            }
            if (pClass.equals(Float.TYPE)) {
                return pObject instanceof Float;
            }
        } else {
            return pObject.getClass().equals(pClass);
        }
        throw new Exception("Type " + pClass.getName() + " not supported");
    }

    private static Object initObjectFromBinary(OmnisToJavaInputStream omnisStream, int pDataType, Class pClassToInit) throws Exception {
        Object rtnObject = null;
        switch (pDataType) {
            case 36: {
                rtnObject = Deserialiser.InitInputObject(pClassToInit, omnisStream, false);
                break;
            }
            case 29: {
                if (omnisStream.available() == 0) break;
                omnisStream.mark(1);
                int oType = omnisStream.readByteAsInt();
                omnisStream.reset();
                switch (oType) {
                    default: 
                }
                ArrayList<Object> curArray = new ArrayList<Object>();
                Class<?> arrayElementClass = pClassToInit.getComponentType();
                Method setter = null;
                boolean noSetter = false;
                boolean primitiveArray = false;
                if (arrayElementClass == null) {
                    Method[] objectSetterMethods = callservice.getMethods(pClassToInit, "set", false);
                    if (objectSetterMethods.length > 1) {
                        if (callservice.enableLogging) {
                            callservice.log("    More than one setter: " + pClassToInit);
                        }
                        throw new Exception("Type " + pClassToInit + "has more than one setter. Arrays of complex types are not supported.");
                    }
                    if (objectSetterMethods.length == 0) {
                        if (callservice.enableLogging) {
                            callservice.log("    No setter: " + pClassToInit);
                        }
                        noSetter = true;
                    } else {
                        setter = objectSetterMethods[0];
                        Class<?>[] paramTypes = setter.getParameterTypes();
                        if (paramTypes.length != 1) {
                            throw new Exception("Type " + pClassToInit + "setter does not have a single parameter");
                        }
                        arrayElementClass = paramTypes[0].getComponentType();
                        if (arrayElementClass == null) {
                            throw new Exception("Type " + pClassToInit + "setter does not have an array parameter");
                        }
                    }
                }
                while (omnisStream.available() > 0) {
                    omnisStream.mark(5);
                    oType = omnisStream.readByteAsInt();
                    int elemLen = omnisStream.readInt();
                    if (oType != 36) {
                        omnisStream.reset();
                        elemLen += 5;
                    }
                    byte[] elemData = new byte[elemLen];
                    omnisStream.read(elemData, 0, elemLen);
                    OmnisToJavaInputStream elemStream = new OmnisToJavaInputStream(elemData);
                    if (noSetter) {
                        if (omnisStream.available() > 0) {
                            throw new Exception("Type " + pClassToInit + "has no setter");
                        }
                        oType = elemStream.readByteAsInt();
                        elemLen = elemStream.readInt();
                        if (oType != 21) {
                            throw new Exception("Type " + pClassToInit + " has incorrect enum data");
                        }
                        String value = new String(elemStream.readAll(), "UTF-8");
                        rtnObject = Deserialiser.initEnum(pClassToInit, value);
                        return rtnObject;
                    }
                    if (arrayElementClass.toString().equals("int")) {
                        oType = elemStream.readByteAsInt();
                        elemLen = elemStream.readInt();
                        if (oType != 26) {
                            throw new Exception("Type " + pClassToInit + " has incorrect enum data");
                        }
                        curArray.add(elemStream.readInt());
                        primitiveArray = true;
                        continue;
                    }
                    if (primitiveArray) {
                        throw new Exception("Type " + pClassToInit + " has mixed types");
                    }
                    curArray.add(Deserialiser.InitInputObject(arrayElementClass, elemStream, setter != null));
                }
                curArray.trimToSize();
                rtnObject = Array.newInstance(arrayElementClass, curArray.size());
                if (!primitiveArray) {
                    rtnObject = curArray.toArray((Object[])rtnObject);
                } else {
                    int[] intArray = new int[curArray.size()];
                    for (int i = 0; i < curArray.size(); ++i) {
                        intArray[i] = (Integer)curArray.get(i);
                    }
                    rtnObject = intArray;
                }
                if (setter != null) {
                    Object actualRtnObject = pClassToInit.newInstance();
                    setter.invoke(actualRtnObject, rtnObject);
                    rtnObject = actualRtnObject;
                }
                omnisStream.mark(2);
                if (omnisStream.readByteAsInt() == 25) {
                    rtnObject = Deserialiser.stringToDoubleArray((String[])rtnObject);
                    break;
                }
                omnisStream.reset();
                break;
            }
            default: {
                rtnObject = Deserialiser.initSimpleFromBinary(omnisStream, pDataType, pClassToInit);
            }
        }
        return rtnObject;
    }

    private static Object initSimpleFromBinary(OmnisToJavaInputStream omnisStream, int pDataType, Class pClassToInit) throws Exception {
        Object rtnObject = null;
        switch (pDataType) {
            case 25: {
                String doubVal = new String(omnisStream.readAll(), "UTF-8");
                rtnObject = new Double(doubVal);
                break;
            }
            case 26: {
                if (omnisStream.available() == 0) {
                    rtnObject = new Integer(0);
                    break;
                }
                rtnObject = omnisStream.readInt();
                break;
            }
            case 64: {
                if (omnisStream.available() == 0) {
                    rtnObject = new Long(0L);
                    break;
                }
                rtnObject = omnisStream.readLong();
                break;
            }
            case 21: {
                rtnObject = new String(omnisStream.readAll(), "UTF-8");
                if (pClassToInit.equals(Token.class)) {
                    Token rtnToken = new Token((String)rtnObject);
                    rtnObject = rtnToken;
                    break;
                }
                if (pClassToInit.equals(Long.TYPE)) {
                    rtnObject = Long.valueOf((String)rtnObject);
                    break;
                }
                if (pClassToInit.equals(Float.TYPE)) {
                    rtnObject = Float.valueOf((String)rtnObject);
                    break;
                }
                if (!pClassToInit.equals(String.class) && Deserialiser.IsEnum(pClassToInit)) {
                    rtnObject = Deserialiser.initEnum(pClassToInit, (String)rtnObject);
                    break;
                }
                rtnObject = Deserialiser.checkForToken(pClassToInit, rtnObject);
                break;
            }
            case 28: {
                ByteArrayDataSource binStream = new ByteArrayDataSource(omnisStream.readAll());
                rtnObject = new DataHandler((DataSource)binStream);
                break;
            }
            case 23: {
                rtnObject = Deserialiser.binaryToCalendar(omnisStream.readAll()).getTime();
                break;
            }
            case 2: {
                rtnObject = new Time(Deserialiser.binaryToCalendar(omnisStream.readAll()));
                break;
            }
            case 1: {
                rtnObject = Deserialiser.binaryToCalendar(omnisStream.readAll());
                break;
            }
            case 22: {
                rtnObject = omnisStream.available() == 0 ? Boolean.valueOf(false) : Boolean.valueOf(omnisStream.readByteAsInt() == 2);
            }
        }
        return rtnObject;
    }

    public Object[] binarayToObjectArray() {
        return null;
    }

    private static double[] stringToDoubleArray(String[] pStringArray) {
        double[] doubArray = new double[pStringArray.length];
        int index = 0;
        for (String curDoub : pStringArray) {
            doubArray[index++] = new Double(curDoub);
        }
        return doubArray;
    }

    private static Calendar binaryToCalendar(byte[] pByteArray) {
        Calendar lDate = Calendar.getInstance();
        lDate.clear();
        if ((pByteArray[8] & 1) == 1) {
            lDate.set(1, 0xFF & pByteArray[0] | (0xFF & pByteArray[1]) << 8);
            lDate.set(2, 0xFF & pByteArray[2]);
            lDate.set(5, 0xFF & pByteArray[3]);
        }
        if ((pByteArray[8] & 2) == 2) {
            lDate.set(10, 0xFF & pByteArray[4]);
            lDate.set(12, 0xFF & pByteArray[5]);
        }
        if ((pByteArray[8] & 4) == 4) {
            lDate.set(13, 0xFF & pByteArray[6]);
        }
        if ((pByteArray[8] & 8) == 8) {
            lDate.set(14, 0xFF & pByteArray[7]);
        }
        return lDate;
    }

    private static Object initEnum(Class pEnumClass, String pEnumVal) throws IllegalArgumentException, NoSuchMethodException {
        Class<?>[] enumSubClasses = pEnumClass.getDeclaredClasses();
        Object enumVal = null;
        if (pEnumVal.length() > 0) {
            try {
                for (int i = 0; i <= enumSubClasses.length; ++i) {
                    if (!enumSubClasses[i].getName().endsWith("Factory")) continue;
                    try {
                        Class[] paramTypes = new Class[]{String.class};
                        Class<?> factoryClass = enumSubClasses[i];
                        Method enumInit = factoryClass.getMethod("fromValue", paramTypes);
                        Object[] enumPars = new Object[]{pEnumVal};
                        enumVal = enumInit.invoke(null, enumPars);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        Class[] paramTypes = new Class[]{Token.class};
                        Class<?> factoryClass = enumSubClasses[i];
                        try {
                            Method enumInit = factoryClass.getMethod("fromValue", paramTypes);
                            Token token = new Token(pEnumVal);
                            Object[] enumPars = new Object[]{token};
                            enumVal = enumInit.invoke(null, enumPars);
                            break;
                        }
                        catch (Exception ex) {
                            if (!(ex.getCause() instanceof IllegalArgumentException)) continue;
                            throw new IllegalArgumentException("String: " + pEnumVal + " not a valid completion of " + pEnumClass.getName());
                        }
                    }
                    catch (Exception e) {
                        if (!(e.getCause() instanceof IllegalArgumentException)) continue;
                        throw new IllegalArgumentException("String: " + pEnumVal + " not a valid completion of " + pEnumClass.getName());
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchMethodException("Unable to find Factory class for " + pEnumClass.getName());
            }
        }
        return enumVal;
    }

    private static Object checkForToken(Class classToInit, Object value) {
        Method[] methods;
        String simpleName = classToInit.getSimpleName();
        for (Method method : methods = callservice.getMethods(classToInit, "set", false)) {
            Class<?> paramClass;
            String methodName = method.getName();
            if (!methodName.endsWith(simpleName) || !(paramClass = method.getParameterTypes()[0]).getCanonicalName().equals("org.apache.axis2.databinding.types.Token")) continue;
            try {
                Token token = new Token(value.toString());
                value = classToInit.newInstance();
                method.invoke(value, token);
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value;
    }

    public static boolean IsEnum(Class pClass) {
        return 0 == callservice.getMethods(pClass, "set", false).length && 0 == pClass.getConstructors().length;
    }
}

