/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.MultiClassLoader;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class URLClassLoader
extends MultiClassLoader {
    private String urlString;

    public URLClassLoader(String urlString, ClassLoader pParent) {
        super(pParent);
        this.urlString = urlString;
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        try {
            URL url = new URL(this.urlString + className);
            URLConnection connection = url.openConnection();
            if (this.sourceMonitorOn) {
                URLClassLoader.print("Loading from URL: " + connection.getURL());
            }
            this.monitor("Content type is: " + connection.getContentType());
            InputStream inputStream = connection.getInputStream();
            int length = connection.getContentLength();
            this.monitor("InputStream length = " + length);
            byte[] data = new byte[length];
            inputStream.read(data);
            inputStream.close();
            return data;
        }
        catch (Exception ex) {
            URLClassLoader.print("### URLClassLoader.loadClassBytes() - Exception:");
            ex.printStackTrace();
            return null;
        }
    }
}

