/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.CoreList;
import JavaCore.CoreObject;
import JavaCore.FileClassLoader;
import JavaCore.JarManager;
import JavaCore.JavaAPI;
import JavaCore.MultiClassLoader;
import JavaCore.ReflectiveInvocation;
import JavaCore.ThreadConsole;
import JavaCore.ThreadControl;
import JavaCore.ThreadState;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Vector;

public class ThreadObject
extends Thread {
    private JarManager jarManager = new JarManager();
    Object[] mDataArr;
    Object mObject;
    String mMethodName;
    Class[] mTypes;
    Object[] mParms;
    Object mResult;
    String mClassName;
    String mClassPath;
    String mObjectID;
    String mClassID;
    String mOpCode;
    boolean mCreateClass;
    CoreList mObjList;
    CoreObject mCObj;
    ThreadState mCoreObj;
    private ThreadControl mControl;
    String mThreadID;
    int mThreadState;
    boolean mIsValid;
    boolean mIsThreadComplete;
    boolean mReturnObjectID;
    public static ThreadConsole tconsole = null;
    public static boolean smGotSystemProperties = false;
    public static boolean smOpenConsole = false;
    public static boolean smThreadLogging = false;
    public static boolean smClassLoaderLogging = false;
    private static ClassLoader smDefaultContextClassLoader = null;
    int mThreadTimeout;
    public static final int kWaiting = 0;
    public static final int kExecuting = 1;
    public static final int kReady = 2;
    public static final int kStopped = 3;
    public static final int kInvalid = 999;
    public static final int kNoError = 0;
    public static final int kNoThreadID = 1;
    public static final int kINoState = 2;
    public static final int kNoThreadStart = 3;
    public static final int kINoSleep = 4;
    public static final int kINoOpCode = 5;
    public static final int kINoInvokeOpCode = 6;
    public static final int kNoClassLoader = 7;
    public static final int kNoClassFound = 8;
    public static final int kNoObjInst = 9;
    public static final int kNoConstruct = 10;
    public static final int kNoInvokeConstruct = 11;
    public static final int kNoObject = 12;
    public static final int kNoMethod = 13;
    public static final int kNoInvokeMethod = 14;
    public static final int kINoThread = 15;
    public static final int kISleepInt = 16;
    public static final int kITermFail = 17;

    ThreadObject(ThreadState pStateObj, CoreObject pCoreObj) {
        this.setThreadConsole();
        this.mCObj = pCoreObj;
        this.mCoreObj = pStateObj;
        this.mControl = null;
        this.mThreadState = 999;
        this.mIsThreadComplete = false;
        this.mThreadTimeout = 20;
        this.mThreadID = "Omnis" + this.getName();
        this.mReturnObjectID = false;
        this.mCreateClass = false;
    }

    private synchronized void setDefaultContextClassLoader() {
        if (null == smDefaultContextClassLoader) {
            smDefaultContextClassLoader = this.getContextClassLoader();
            if (System.getProperty("omnis.state.ineclipse").equals("1")) {
                try {
                    Class<?> c = Class.forName("net.omnis.webcore.webservices.callservice");
                    if (c != null) {
                        Method m = c.getMethod("setEclipseContextClassLoader", ClassLoader.class);
                        JavaAPI.smCallServiceClass = c;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized ClassLoader getDefaultContextClassLoader() {
        this.setDefaultContextClassLoader();
        return smDefaultContextClassLoader;
    }

    public static ClassLoader getEclipseContextClassLoader() {
        return smDefaultContextClassLoader;
    }

    private synchronized void setThreadConsole() {
        if (!smGotSystemProperties) {
            smGotSystemProperties = true;
            if (smThreadLogging || smClassLoaderLogging || smOpenConsole) {
                tconsole = new ThreadConsole();
            }
        }
    }

    public void setController(ThreadControl pControl) {
        this.mControl = pControl;
    }

    public String getThreadID() {
        return this.mThreadID;
    }

    public String getClassName() {
        String retval = "";
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getClassName();
        }
        return retval;
    }

    public String getClassPath() {
        String retval = "";
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getClassPath();
        }
        return retval;
    }

    public String getMethodName() {
        String retval = "";
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getMethodName();
        }
        return retval;
    }

    public Class[] getMethodTypes() {
        Class[] retval = null;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getMethodTypes();
        }
        return retval;
    }

    public Object[] getMethodParms() {
        Object[] retval = null;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getMethodParms();
        }
        return retval;
    }

    public String getObjectID() {
        String retval = "";
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getObjectID();
        }
        return retval;
    }

    public String getClassID() {
        String retval = "";
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getClassID();
        }
        return retval;
    }

    public boolean getClassFlag() {
        boolean retval = false;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getClassFlag();
        }
        return retval;
    }

    public String getOpCode() {
        String retval = "";
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getOpCode();
        }
        return retval;
    }

    public Object[] getDataArray() {
        Object[] retval = null;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getDataArray();
        }
        return retval;
    }

    public void setResult(Object pObject) {
        if (this.mCoreObj != null) {
            this.mCoreObj.setResult(pObject);
        }
    }

    public void setThreadState(int pThreadState) {
        if (this.mCoreObj != null) {
            this.mCoreObj.setThreadState(pThreadState);
        }
    }

    public int getThreadState() {
        int retval = 999;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getThreadState();
        }
        return retval;
    }

    public void setThreadStarted(boolean pFlag) {
        if (this.mCoreObj != null) {
            this.mCoreObj.setThreadStarted(pFlag);
        }
    }

    public boolean isThreadStarted() {
        boolean retval = false;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.isThreadStarted();
        }
        return retval;
    }

    public void setThreadComplete(boolean pFlag) {
        if (this.mCoreObj != null) {
            this.mCoreObj.setThreadComplete(pFlag);
        }
    }

    public void ECOtestThread() {
    }

    public boolean getObjectReturn() {
        boolean retval = false;
        if (this.mCoreObj != null) {
            retval = this.mCoreObj.getObjectReturn();
        }
        return retval;
    }

    public void setLastError(long pErrCode, String pJVMString) {
        if (this.mCoreObj != null) {
            this.mCoreObj.setJavaError(pErrCode, pJVMString);
        }
    }

    public void setLastError(long pErrCode) {
        if (this.mCoreObj != null) {
            this.mCoreObj.setJavaError(pErrCode);
        }
    }

    private void waitForOther() {
        this.mCObj.waitForOther();
    }

    public void run() {
        if (smThreadLogging) {
            tconsole.println("Starting up.., Setting Thread Started flag");
        }
        this.waitForOther();
        this.setThreadStarted(true);
        if (smThreadLogging) {
            tconsole.println("Wait complete (state sync at startup)");
        }
        this.mThreadState = 0;
        this.setThreadState(this.mThreadState);
        if (smThreadLogging) {
            tconsole.println("Waiting For ThreadController (startup)");
        }
        this.waitForOther();
        if (smThreadLogging) {
            tconsole.println("Starting Java Session..");
        }
        while (this.mThreadState != 3) {
            this.waitForOther();
            if (smThreadLogging) {
                tconsole.println("Wait complete (Synchronizing thread state)");
            }
            this.mThreadState = this.getThreadState();
            if (this.mThreadState != 2) continue;
            if (smThreadLogging) {
                tconsole.println("Getting state from state object..");
            }
            this.mOpCode = this.getOpCode();
            if (smThreadLogging) {
                tconsole.println("Executing " + this.mOpCode);
            }
            this.mClassName = this.getClassName();
            this.mClassPath = this.getClassPath();
            this.mMethodName = this.getMethodName();
            this.mParms = this.getMethodParms();
            this.mTypes = this.getMethodTypes();
            this.mObjectID = this.getObjectID();
            this.mClassID = this.getClassID();
            this.mCreateClass = this.getClassFlag();
            this.mReturnObjectID = this.getObjectReturn();
            this.mDataArr = this.getDataArray();
            this.setLastError(0L);
            this.executeOpCode();
            if (smThreadLogging) {
                tconsole.println("Setting state to kWaiting..");
            }
            this.mThreadState = 0;
            this.setThreadState(this.mThreadState);
            if (smThreadLogging) {
                tconsole.println("Waiting For ThreadController (execution)");
            }
            this.waitForOther();
            if (!smThreadLogging) continue;
            tconsole.println("Wait complete (execution)");
        }
        if (smThreadLogging) {
            tconsole.println("Thread " + this.mThreadID + " has stopped");
        }
        this.jarManager.unloadAll();
    }

    private void executeOpCode() {
        Class<?> lclass = this.getClass();
        Method lmethod = null;
        try {
            lmethod = lclass.getDeclaredMethod(this.mOpCode, null);
        }
        catch (Exception e) {
            String err = e + " ";
            Throwable lthrow = e.getCause();
            if (lthrow != null) {
                err = err + lthrow.getMessage() + " ";
            }
            this.setLastError(5L, err);
            if (smThreadLogging) {
                tconsole.println("Thread " + this.mThreadID + " executeOpCode: Exception" + e + " method = " + this.mOpCode);
            }
            return;
        }
        try {
            lmethod.invoke((Object)this, (Object[])null);
        }
        catch (Exception e1) {
            String err = e1 + " ";
            Throwable lthrow = e1.getCause();
            if (lthrow != null) {
                err = err + lthrow.getMessage() + " ";
            }
            this.setLastError(6L, err);
            if (smThreadLogging) {
                tconsole.println("Thread " + this.mThreadID + " executeOpCode: Exception" + e1 + " method = " + this.mOpCode);
            }
            return;
        }
    }

    private String createJavaObject() {
        this.setContextClassLoader(this.getDefaultContextClassLoader());
        String retval = "";
        MultiClassLoader loader = null;
        this.mObject = null;
        String clspath = System.getProperty(JavaAPI.ECOgetClassPathProperty());
        if (smClassLoaderLogging) {
            tconsole.println("createJavaObject: CLASSPATH = " + clspath);
        }
        if (this.mClassPath != null) {
            if (this.mClassPath.lastIndexOf(".jar") > 0) {
                loader = this.jarManager.getInstance(this.mClassPath, JavaAPI.getInEclipse() ? smDefaultContextClassLoader : null);
                if (smClassLoaderLogging) {
                    tconsole.println("Using JAR loader for " + this.mClassPath);
                }
            } else {
                loader = new FileClassLoader(this.mClassPath, JavaAPI.getInEclipse() ? smDefaultContextClassLoader : null);
                if (smClassLoaderLogging) {
                    tconsole.println("Using file loader for " + this.mClassPath);
                }
            }
        } else {
            loader = new FileClassLoader(this.mClassPath, JavaAPI.getInEclipse() ? smDefaultContextClassLoader : null);
            if (smClassLoaderLogging) {
                tconsole.println("Using file loader for null class path");
            }
        }
        if (loader == null) {
            this.setLastError(7L);
            if (smClassLoaderLogging) {
                tconsole.println("createJavaObject: FAILED TO CREATE CLASS LOADER..");
            }
            return retval;
        }
        Class objClass = null;
        try {
            objClass = loader.loadClass(this.mClassName);
        }
        catch (Exception ex) {
            String err = ex + " ";
            Throwable lthrow = ex.getCause();
            if (lthrow != null) {
                err = err + lthrow.getMessage() + " ";
            }
            this.setLastError(8L, err);
            if (smClassLoaderLogging) {
                tconsole.println("createJavaObject: loadClass() failed with exception :" + ex);
                ex.printStackTrace();
            }
            return retval;
        }
        if (smClassLoaderLogging) {
            tconsole.println("Loaded class " + objClass.getName());
        }
        if (!this.mCreateClass) {
            try {
                this.mObject = objClass.newInstance();
            }
            catch (Exception ex) {
                String err = ex + " ";
                Throwable lthrow = ex.getCause();
                if (lthrow != null) {
                    err = err + lthrow.getMessage() + " ";
                }
                this.setLastError(9L, err);
                if (smClassLoaderLogging) {
                    tconsole.println("createJavaObject: newInstance() failed with exception :" + ex);
                    ex.printStackTrace();
                }
                return retval;
            }
        }
        if (this.mObjList == null) {
            this.mObjList = new CoreList();
        }
        if (!this.mCreateClass) {
            retval = this.mObjectID == null ? this.mObjList.addObject(this.mObject) : this.mObjList.addObject(this.mObject, this.mObjectID);
        } else {
            if (smClassLoaderLogging) {
                tconsole.println("adding " + objClass + " to class list");
            }
            retval = this.mObjList.addClass(objClass);
        }
        this.mObject = null;
        this.setResult(retval);
        if (smClassLoaderLogging) {
            tconsole.println("createJavaObject: End Of Function........");
        }
        return retval;
    }

    private Constructor findGenericConstructor(Class pClass) {
        Constructor entry;
        block4: {
            if (smThreadLogging) {
                tconsole.println("Attempt to find constructor signature");
            }
            entry = null;
            try {
                long start = System.currentTimeMillis();
                entry = ReflectiveInvocation.findConstructor(pClass, this.mParms);
                long timeTaken = System.currentTimeMillis() - start;
                if (smThreadLogging) {
                    tconsole.println("Method found using ReflectiveInvocation" + timeTaken);
                }
            }
            catch (Exception exm3) {
                entry = null;
                if (!smThreadLogging) break block4;
                tconsole.println("Signature not found");
            }
        }
        return entry;
    }

    private String constructJavaObject() {
        Throwable lthrow;
        String err;
        Object lobject;
        Constructor centry;
        String retval;
        block10: {
            retval = "";
            centry = null;
            Class lclass = null;
            lobject = null;
            lclass = this.mObjList.findObjectClass(this.mClassID);
            if (lclass == null) {
                return retval;
            }
            try {
                centry = lclass.getConstructor(this.mTypes);
            }
            catch (Exception e) {
                err = e + " ";
                lthrow = e.getCause();
                if (lthrow != null) {
                    err = err + lthrow.getMessage() + " ";
                }
                if (smThreadLogging) {
                    tconsole.println("callJavaMethod: Failed to get method with exception: " + e);
                    e.printStackTrace();
                }
                if ((centry = this.findGenericConstructor(lclass)) != null) break block10;
                this.setLastError(10L, err);
                if (smThreadLogging) {
                    tconsole.println("constructJavaInstance: Failed to get constructor with exception: " + e);
                }
                return retval;
            }
        }
        try {
            lobject = centry.newInstance(this.mParms);
        }
        catch (Exception e) {
            err = e + " ";
            lthrow = e.getCause();
            if (lthrow != null) {
                err = err + lthrow.getMessage() + " ";
            }
            this.setLastError(11L, err);
            if (smThreadLogging) {
                tconsole.println("constructJavaInstance: Failed to call constructor with exception: " + e);
            }
            return retval;
        }
        retval = this.mObjectID == null ? this.mObjList.addObject(lobject) : this.mObjList.addObject(lobject, this.mObjectID);
        this.setResult(retval);
        return retval;
    }

    private Method findGenericMethod(Object pObject, Class pClass) {
        Method entry;
        block19: {
            int typelen;
            if (smThreadLogging) {
                tconsole.println("Attempt to find method signature");
            }
            entry = null;
            Class lclass = null;
            int i = 0;
            try {
                for (typelen = 0; typelen > -1; ++typelen) {
                    lclass = this.mTypes[typelen];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            Object lobj = new Object();
            if (typelen > 0) {
                Class[] ltypes = new Class[typelen];
                for (i = 0; i < typelen; ++i) {
                    String type = this.mTypes[i].getName();
                    ltypes[i] = type.equals("java.lang.String") || type.equals("java.util.Date") || type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("short") || type.equals("int") || type.equals("float") || type.equals("long") || type.equals("double") || type.equals("[Ljava.lang.String") || type.equals("[Ljava.util.Date") || type.equals("[Z") || type.equals("[C") || type.equals("[B") || type.equals("[S") || type.equals("[I") || type.equals("[F") || type.equals("[J") || type.equals("[D") ? this.mTypes[i] : (type.equals("java.util.GregorianCalendar") ? Calendar.class : lobj.getClass());
                    if (!smThreadLogging) continue;
                    tconsole.println("Param" + i + ": " + ltypes[i] + " (" + type + ")");
                }
                try {
                    entry = pClass.getMethod(this.mMethodName, ltypes);
                    if (smThreadLogging) {
                        tconsole.println("Found signature");
                    }
                }
                catch (Exception exm) {
                    for (i = 0; i < typelen; ++i) {
                        ltypes[i] = lobj.getClass();
                    }
                    try {
                        entry = pClass.getMethod(this.mMethodName, ltypes);
                        if (smThreadLogging) {
                            tconsole.println("Found totally generic signature");
                        }
                    }
                    catch (Exception exm2) {
                        try {
                            long start = System.currentTimeMillis();
                            if (pObject == null) {
                                entry = ReflectiveInvocation.findStaticMethod(pClass, this.mMethodName, this.mParms);
                                long timeTaken = System.currentTimeMillis() - start;
                                if (smThreadLogging) {
                                    tconsole.println("Static method found using ReflectiveInvocation" + timeTaken);
                                }
                            } else {
                                entry = ReflectiveInvocation.findMethod(pObject, this.mMethodName, this.mParms);
                                long timeTaken = System.currentTimeMillis() - start;
                                if (smThreadLogging) {
                                    tconsole.println("Method found using ReflectiveInvocation" + timeTaken);
                                }
                            }
                        }
                        catch (Exception exm3) {
                            entry = null;
                            if (!smThreadLogging) break block19;
                            tconsole.println("Signature not found");
                        }
                    }
                }
            }
        }
        return entry;
    }

    private Object invokeJavaMethod(Object pObject, Class pClass) {
        Object lresult;
        String objID;
        block16: {
            Throwable lthrow;
            String err;
            Method entry;
            block15: {
                if (smThreadLogging) {
                    tconsole.println("invokeJavaMethod In... (" + this.mMethodName + ")");
                }
                entry = null;
                objID = null;
                lresult = null;
                if (smThreadLogging) {
                    tconsole.println("Attempting to execute: " + this.mMethodName);
                }
                try {
                    entry = pClass.getMethod(this.mMethodName, this.mTypes);
                }
                catch (Exception exm) {
                    err = exm + " ";
                    lthrow = exm.getCause();
                    if (lthrow != null) {
                        err = err + lthrow.getMessage() + " ";
                    }
                    if (smThreadLogging) {
                        tconsole.println("callJavaMethod: Failed to get method with exception: " + exm);
                        exm.printStackTrace();
                    }
                    if ((entry = this.findGenericMethod(pObject, pClass)) != null) break block15;
                    this.setLastError(13L, err);
                    return lresult;
                }
            }
            try {
                lresult = entry.invoke(pObject, this.mParms);
            }
            catch (Exception exm) {
                err = exm + " ";
                lthrow = exm.getCause();
                if (lthrow != null) {
                    err = err + lthrow.getMessage() + " ";
                }
                this.setLastError(14L, err);
                if (!smThreadLogging) break block16;
                tconsole.println("callJavaMethod: Failed to invoke method with exception: " + exm);
                exm.printStackTrace();
            }
        }
        if (this.mReturnObjectID) {
            if (lresult == null) {
                this.setResult(lresult);
            } else {
                if (smThreadLogging) {
                    tconsole.println("mReturnObjectID is true");
                }
                objID = this.mObjList.addObject(lresult);
                this.setResult(objID);
                lresult = objID;
            }
        } else {
            if (smThreadLogging) {
                tconsole.println("mReturnObjectID is false");
            }
            this.setResult(lresult);
        }
        return lresult;
    }

    private Object callJavaMethod() {
        Object lobject = null;
        Object lresult = null;
        if (this.mObjectID != null) {
            lobject = this.mObjList.findObject(this.mObjectID);
        }
        if (lobject == null) {
            Class lclass = null;
            lclass = this.mObjList.findObjectClass(this.mClassID);
            if (lclass != null) {
                lresult = this.invokeJavaMethod(null, lclass);
            } else {
                this.setLastError(12L);
                if (smThreadLogging) {
                    tconsole.println("callJavaMethod: Error, could not find object for ID " + this.mObjectID);
                }
            }
        } else {
            lresult = this.invokeJavaMethod(lobject, lobject.getClass());
        }
        return lresult;
    }

    private void getJavaObject() {
        Object lobj = null;
        lobj = this.mObjList.findObject(this.mObjectID);
        this.setResult(lobj);
    }

    private void getJavaClass() {
        Class lobj = null;
        lobj = this.mObjList.findObjectClass(this.mObjectID);
        this.setResult(lobj);
    }

    private void disposeJavaObject() {
        this.mObjList.removeObject(this.mObjectID);
    }

    private Object createObjectsFromList() {
        Vector<String> lidlist = null;
        Object retval = null;
        Object element = null;
        String objid = null;
        if (this.mDataArr == null) {
            return null;
        }
        lidlist = new Vector<String>();
        try {
            for (int i = 0; i > -1; ++i) {
                element = this.mDataArr[i];
                objid = this.mObjList.addObject(element);
                lidlist.addElement(objid);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        element = lidlist.toArray();
        this.setResult(element);
        return element;
    }
}

