/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class ThreadConsole
extends Frame {
    private static final long serialVersionUID = 1L;
    private TextArea ta;
    private PrintStream out;
    private PrintStream err;
    private final Object hookLock = new Object();

    public ThreadConsole() {
        this(500, 400);
    }

    public ThreadConsole(int width, int height) {
        this.ta = new TextArea();
        this.setLayout(new BorderLayout());
        this.add("Center", this.ta);
        this.setSize(width, height);
        this.setVisible(true);
        this.hookStandards();
        this.ta.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
                switch (ke.getKeyChar()) {
                    case 'd': {
                        break;
                    }
                    case 'c': {
                        ThreadConsole.this.ta.setText("");
                    }
                }
                ke.consume();
            }

            public void keyReleased(KeyEvent ke) {
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
    }

    public synchronized void println(int i) {
        this.println("" + i);
    }

    public synchronized void println(long l) {
        this.println("" + l);
    }

    public synchronized void println(double d) {
        this.println("" + d);
    }

    public synchronized void println(String s) {
        this.println((Object)s);
    }

    public synchronized void println(Object o) {
        this.showString(Thread.currentThread().getName() + ": " + o.toString() + "\n");
    }

    public synchronized void print(int i) {
        this.print("" + i);
    }

    public synchronized void print(long l) {
        this.print("" + l);
    }

    public synchronized void print(double d) {
        this.print("" + d);
    }

    public synchronized void print(String s) {
        this.print((Object)s);
    }

    public synchronized void print(Object o) {
        this.showString(o.toString());
    }

    private void showString(Object o) {
        this.ta.append(o.toString());
    }

    private void closeit() {
        this.unhookStandards();
        this.setVisible(false);
    }

    public void close() {
        this.closeit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hookStandards() {
        Object object = this.hookLock;
        synchronized (object) {
            if (this.out != null) {
                return;
            }
            this.out = System.out;
            this.err = System.err;
            PrintStream dwout = new PrintStream(new ThreadConsoleOutputStream(this));
            System.setOut(dwout);
            System.setErr(dwout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhookStandards() {
        Object object = this.hookLock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            System.setOut(this.out);
            System.setErr(this.err);
            this.out = null;
            this.err = null;
        }
    }

    private class ThreadConsoleOutputStream
    extends OutputStream {
        public ThreadConsole mConsole;

        public ThreadConsoleOutputStream(ThreadConsole pConsole) {
            this.mConsole = pConsole;
        }

        public synchronized void write(int b) {
            byte[] ba = new byte[]{(byte)b};
            this.write(ba, 0, 1);
        }

        public synchronized void write(byte[] b, int off, int len) {
            try {
                this.mConsole.print(new String(b, off, len, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return;
            }
        }

        public void close() throws IOException {
        }
    }
}

