/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.RIInfo;
import JavaCore.RunnableWithResult;
import JavaCore.ThreadObject;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class ReflectiveInvocation
implements RunnableWithResult {
    protected Object _target = null;
    protected Constructor _constructor = null;
    protected Method _method = null;
    protected Object[] _arguments = null;
    protected Object _result;
    protected Exception _exception;
    protected static final int OK = 0;
    protected static final int NOSUCHMETHOD = 1;
    protected static final int SECURITY = 2;
    protected static final int ILLEGALARGUMENT = 3;
    protected static final int NULLPOINTER = 4;

    public static boolean verifyMethod(Object target, Method method, Object[] arguments) {
        int exception = 0;
        String message = "";
        if (method == null) {
            exception = 4;
            message = "Must specify method object";
        } else {
            int modifiers = method.getModifiers();
            int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
            if (!Modifier.isPublic(modifiers)) {
                exception = 2;
                message = "Supplied method not public";
            } else if (target == null && !Modifier.isStatic(modifiers)) {
                exception = 3;
                message = "Require static method with null target";
            } else if (method.getParameterTypes().length != noArgs) {
                exception = 3;
                message = "Wrong number of parameters for method";
            }
        }
        if (exception != 0) {
            try {
                ReflectiveInvocation.throwException(exception, message);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean verifyConstructor(Constructor constructor, Object[] arguments) {
        int exception = 0;
        String message = "";
        if (constructor == null) {
            exception = 4;
            message = "Must specify constructor object";
        } else {
            int modifiers = constructor.getModifiers();
            int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
            if (!Modifier.isPublic(modifiers)) {
                exception = 2;
                message = "Supplied constructor not public";
            } else if (constructor.getParameterTypes().length != noArgs) {
                exception = 3;
                message = "Wrong number of parameters for constructor";
            }
        }
        if (exception != 0) {
            try {
                ReflectiveInvocation.throwException(exception, message);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return true;
    }

    public static Method findMethod(Object target, String name, Object[] arguments) throws NoSuchMethodException {
        Method method = null;
        int exception = 0;
        String message = "";
        ArrayList matches = new ArrayList();
        if (target == null || name == null) {
            exception = 4;
            message = "Must specify target object and method name";
        } else {
            int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
            ReflectiveInvocation.findMatchingMethods(target.getClass(), name, noArgs, matches);
            if (!matches.isEmpty()) {
                try {
                    method = (Method)ReflectiveInvocation.findBestMatch(arguments, matches);
                }
                catch (ClassCastException e) {
                    method = null;
                }
                if (method == null) {
                    exception = 1;
                    message = "No best match for public method " + name + " for class " + target.getClass().getName();
                }
            } else {
                exception = 1;
                message = "Public method " + name + " not found for class " + target.getClass().getName();
            }
        }
        if (exception != 0) {
            ReflectiveInvocation.throwException(exception, message);
        }
        return method;
    }

    public static Method findStaticMethod(Class cls, String name, Object[] arguments) throws NoSuchMethodException {
        Method method = null;
        String message = "";
        int exception = 0;
        ArrayList matches = new ArrayList();
        if (cls == null) {
            message = "Require target class for static method lookup.";
            exception = 4;
        } else if (name == null) {
            message = "Require method name for static method lookup.";
            exception = 4;
        } else {
            int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
            ReflectiveInvocation.findMatchingMethods(cls, name, noArgs, matches);
            ReflectiveInvocation.removeInstanceMethods(matches);
            if (!matches.isEmpty()) {
                try {
                    method = (Method)ReflectiveInvocation.findBestMatch(arguments, matches);
                }
                catch (ClassCastException e) {
                    method = null;
                }
                if (method == null) {
                    exception = 1;
                    message = "No best match for public static method " + name + " for class " + cls.getName();
                }
            } else {
                exception = 1;
                message = "Public static method " + name + " not found for class " + cls.getName();
            }
        }
        if (exception != 0) {
            ReflectiveInvocation.throwException(exception, message);
        }
        return method;
    }

    public static Constructor findConstructor(String name, Object[] arguments) throws NoSuchMethodException {
        Constructor constructor = null;
        int exception = 0;
        String message = "";
        ArrayList matches = new ArrayList();
        if (name == null) {
            exception = 4;
            message = "Must specify constructor name";
        } else {
            int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
            ReflectiveInvocation.findMatchingConstructors(name, noArgs, matches);
            if (!matches.isEmpty()) {
                try {
                    constructor = (Constructor)ReflectiveInvocation.findBestMatch(arguments, matches);
                }
                catch (ClassCastException e) {
                    constructor = null;
                }
                if (constructor == null) {
                    exception = 1;
                    message = "No best match for public constructor " + name;
                }
            } else {
                exception = 1;
                message = "Public constructor " + name + " not found";
            }
        }
        if (exception != 0) {
            ReflectiveInvocation.throwException(exception, message);
        }
        return constructor;
    }

    public static Constructor findConstructor(Class cls, Object[] arguments) throws NoSuchMethodException {
        Constructor constructor = null;
        int exception = 0;
        String message = "";
        ArrayList matches = new ArrayList();
        if (cls == null) {
            exception = 4;
            message = "Must specify class to be instaniated.";
        } else {
            int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
            ReflectiveInvocation.findMatchingConstructors(cls, noArgs, matches);
            if (!matches.isEmpty()) {
                try {
                    constructor = (Constructor)ReflectiveInvocation.findBestMatch(arguments, matches);
                }
                catch (ClassCastException e) {
                    constructor = null;
                }
                if (constructor == null) {
                    exception = 1;
                    message = "No best match for public constructor " + cls.getName();
                }
            } else {
                exception = 1;
                message = "Public constructor for class " + cls.getName() + " not found";
            }
        }
        if (exception != 0) {
            ReflectiveInvocation.throwException(exception, message);
        }
        return constructor;
    }

    public ReflectiveInvocation(Object target, String method, Object[] args) throws NoSuchMethodException {
        if (target == null) {
            this._constructor = ReflectiveInvocation.findConstructor(method, args);
        } else {
            this._method = ReflectiveInvocation.findMethod(target, method, args);
        }
        this._target = target;
        this._arguments = args;
    }

    public ReflectiveInvocation(String constructor, Object[] args) throws NoSuchMethodException {
        this._constructor = ReflectiveInvocation.findConstructor(constructor, args);
        this._arguments = args;
    }

    public ReflectiveInvocation(Class cls, Object[] args) throws NoSuchMethodException {
        this._constructor = ReflectiveInvocation.findConstructor(cls, args);
        this._arguments = args;
    }

    public ReflectiveInvocation(Class cls, String method, Object[] args) throws NoSuchMethodException {
        if (cls != null) {
            this._method = ReflectiveInvocation.findStaticMethod(cls, method, args);
            this._target = null;
        } else {
            this._constructor = ReflectiveInvocation.findConstructor(method, args);
        }
        this._arguments = args;
    }

    public ReflectiveInvocation(Object target, Method method, Object[] args) {
        if (ReflectiveInvocation.verifyMethod(target, method, args)) {
            this._target = target;
            this._method = method;
            this._arguments = args;
        }
    }

    public ReflectiveInvocation(Constructor constructor, Object[] args) {
        if (ReflectiveInvocation.verifyConstructor(constructor, args)) {
            this._constructor = constructor;
            this._arguments = args;
        }
    }

    public void run() {
        try {
            if (this._method != null) {
                this._result = this._method.invoke(this._target, this._arguments);
            } else if (this._constructor != null) {
                this._result = this._constructor.newInstance(this._arguments);
            }
        }
        catch (InvocationTargetException e) {
            if (ThreadObject.smThreadLogging) {
                ThreadObject.tconsole.println("ReflectiveInvocation failure - Exception " + e.getTargetException().toString());
            }
            e.getTargetException().printStackTrace();
            this._exception = e;
        }
        catch (Exception e) {
            if (ThreadObject.smThreadLogging) {
                ThreadObject.tconsole.println("ReflectiveInvocation failure - Exception " + e.getClass().getName());
            }
            e.printStackTrace();
            this._exception = e;
        }
    }

    public Object getResult() {
        return this._result;
    }

    public Exception getException() {
        return this._exception;
    }

    public String toString() {
        StringBuilder temp = new StringBuilder();
        if (this._target != null) {
            temp.append(this._target.getClass());
        }
        if (this._constructor != null) {
            temp.append(this._constructor.toString());
        }
        if (this._method != null) {
            temp.append(this._method.toString());
        }
        return temp.toString();
    }

    protected static int getNumberOfArguments(Object[] arguments) {
        int numberArgs = arguments == null ? 0 : arguments.length;
        return numberArgs;
    }

    protected static void throwException(int exceptionNumber, String message) throws SecurityException, NoSuchMethodException, IllegalArgumentException {
        switch (exceptionNumber) {
            case 0: {
                break;
            }
            case 1: {
                throw new NoSuchMethodException(message);
            }
            case 2: {
                throw new SecurityException(message);
            }
            case 3: {
                throw new IllegalArgumentException(message);
            }
            case 4: {
                throw new NullPointerException(message);
            }
            default: {
                throw new InternalError("Unrecognized exception code.");
            }
        }
    }

    protected static void findMatchingMethods(Class targetClass, String name, int noArguments, ArrayList matches) {
        Method[] methodList = targetClass.getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            if (!Modifier.isPublic(methodList[i].getModifiers()) || !methodList[i].getName().equals(name) || noArguments != methodList[i].getParameterTypes().length) continue;
            RIInfo item = new RIInfo(methodList[i], (Class[])methodList[i].getParameterTypes());
            matches.add(item);
        }
    }

    protected static void findMatchingConstructors(String name, int noArguments, ArrayList matches) {
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
            ReflectiveInvocation.findMatchingConstructors(cls, noArguments, matches);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void findMatchingConstructors(Class targetClass, int noArguments, ArrayList matches) {
        Constructor<?>[] conList = targetClass.getConstructors();
        for (int i = 0; i < conList.length; ++i) {
            if (!Modifier.isPublic(conList[i].getModifiers()) || noArguments != conList[i].getParameterTypes().length) continue;
            RIInfo item = new RIInfo(conList[i], (Class[])conList[i].getParameterTypes());
            matches.add(item);
        }
    }

    protected static void removeInstanceMethods(ArrayList matches) {
        boolean notDone = true;
        block0: while (notDone) {
            notDone = false;
            for (RIInfo item : matches) {
                if (Modifier.isStatic(item.getMember().getModifiers())) continue;
                matches.remove(item);
                notDone = true;
                continue block0;
            }
        }
    }

    protected static Member findBestMatch(Object[] arguments, ArrayList matches) {
        int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
        Class[] argTypes = ReflectiveInvocation.getArgumentTypes(arguments, noArgs);
        ReflectiveInvocation.calculateChecksums(matches, argTypes);
        return ReflectiveInvocation.findMinimumChecksum(matches);
    }

    protected static void calculateChecksums(ArrayList matches, Class[] argTypes) {
        for (RIInfo item : matches) {
            int checksum = ReflectiveInvocation.calculateChecksum(item.getArgumentTypes(), argTypes);
            item.setChecksum(checksum);
        }
    }

    protected static Member findMinimumChecksum(ArrayList matches) {
        int itemChecksum;
        Member bestMember = null;
        int bestChecksum = Integer.MAX_VALUE;
        for (RIInfo item : matches) {
            itemChecksum = item.getChecksum();
            if (itemChecksum < 0 || itemChecksum >= bestChecksum) continue;
            bestChecksum = itemChecksum;
            bestMember = item.getMember();
        }
        boolean found = false;
        for (RIInfo item : matches) {
            itemChecksum = item.getChecksum();
            if (itemChecksum == bestChecksum && !found) {
                found = true;
                continue;
            }
            if (itemChecksum != bestChecksum || !found) continue;
            bestMember = null;
            break;
        }
        return bestMember;
    }

    protected static Class[] getArgumentTypes(Object[] arguments, int noArgs) {
        Class[] types = new Class[noArgs];
        for (int i = 0; i < noArgs; ++i) {
            types[i] = arguments[i] == null ? null : arguments[i].getClass();
        }
        return types;
    }

    protected static int calculateChecksum(Class[] parameters, Class[] arguments) {
        int checksum = 0;
        int noArgs = ReflectiveInvocation.getNumberOfArguments(arguments);
        for (int i = 0; i < noArgs; ++i) {
            int status;
            if (parameters[i].isPrimitive()) {
                status = ReflectiveInvocation.getPrimitiveChecksum(parameters[i], arguments[i]);
                if (status == -1) {
                    checksum = -1;
                    break;
                }
                checksum += status;
                continue;
            }
            if (arguments[i] == null) continue;
            if (parameters[i].isAssignableFrom(arguments[i])) {
                if (parameters[i].isInterface()) {
                    ++checksum;
                    continue;
                }
                if (parameters[i].isArray()) {
                    status = ReflectiveInvocation.getArrayChecksum(parameters[i], arguments[i]);
                    checksum += status;
                    continue;
                }
                checksum += ReflectiveInvocation.distanceFromClass(arguments[i], parameters[i]);
                continue;
            }
            checksum = -1;
            break;
        }
        return checksum;
    }

    protected static int getPrimitiveChecksum(Class parameter, Class argument) {
        int status = -1;
        Class primitive = ReflectiveInvocation.convertObjectToPrimitive(argument);
        if (primitive != null && (status = ReflectiveInvocation.checkPrimitives(primitive, parameter)) != -1) {
            ++status;
        }
        return status;
    }

    protected static int getArrayChecksum(Class parameter, Class argument) {
        int checksum = -1;
        Class<?> paramComponent = parameter.getComponentType();
        Class<?> argComponent = argument.getComponentType();
        if (paramComponent != null && argComponent != null) {
            if (paramComponent.isInterface()) {
                checksum = 1;
            } else if (!paramComponent.isPrimitive() && !argComponent.isPrimitive()) {
                checksum = ReflectiveInvocation.distanceFromClass(argComponent, paramComponent);
            } else if (paramComponent.isPrimitive() && argComponent.isPrimitive() && paramComponent.equals(argComponent)) {
                checksum = 0;
            }
        }
        return checksum;
    }

    protected static int distanceFromClass(Class subclass, Class superclass) {
        int distance = 0;
        for (Class tempClass = subclass; tempClass != superclass && tempClass != null; tempClass = tempClass.getSuperclass()) {
            ++distance;
        }
        return distance;
    }

    protected static int checkPrimitives(Class from, Class to) {
        int checkSum = 0;
        if (from != to) {
            checkSum = ReflectiveInvocation.isCompatiblePrimitives(from, to) ? ++checkSum : -1;
        }
        return checkSum;
    }

    protected static Class convertObjectToPrimitive(Class object) {
        Class<Serializable> primitive = object == null ? null : (object.getName().equals("java.lang.Boolean") ? Boolean.TYPE : (object.getName().equals("java.lang.Character") ? Character.TYPE : (object.getName().equals("java.lang.Byte") ? Byte.TYPE : (object.getName().equals("java.lang.Short") ? Short.TYPE : (object.getName().equals("java.lang.Integer") ? Integer.TYPE : (object.getName().equals("java.lang.Long") ? Long.TYPE : (object.getName().equals("java.lang.Float") ? Float.TYPE : (object.getName().equals("java.lang.Double") ? Double.TYPE : null))))))));
        return primitive;
    }

    protected static boolean isCompatiblePrimitives(Class from, Class to) {
        boolean result = false;
        if (from.isPrimitive() && to.isPrimitive()) {
            if (to == from) {
                result = true;
            } else if (to != Boolean.TYPE) {
                if (from == Byte.TYPE) {
                    result = true;
                } else if (from == Short.TYPE || from == Character.TYPE) {
                    if (to != Byte.TYPE) {
                        result = true;
                    }
                } else if (from == Integer.TYPE) {
                    if (to != Byte.TYPE && to != Short.TYPE && to != Character.TYPE) {
                        result = true;
                    }
                } else if (from == Long.TYPE) {
                    if (to == Float.TYPE || to == Double.TYPE) {
                        result = true;
                    }
                } else if (from == Float.TYPE) {
                    if (to == Double.TYPE) {
                        result = true;
                    }
                } else if (from == Double.TYPE) {
                    // empty if block
                }
            }
        }
        return result;
    }
}

