/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.StringTable;

public class JavaError {
    public static final int kNoError = 0;
    public static final int kNoThreadID = 1;
    public static final int kINoState = 2;
    public static final int kNoThreadStart = 3;
    public static final int kINoSleep = 4;
    public static final int kINoOpCode = 5;
    public static final int kINoInvokeOpCode = 6;
    public static final int kNoClassLoader = 7;
    public static final int kNoClassFound = 8;
    public static final int kNoObjInst = 9;
    public static final int kNoConstruct = 10;
    public static final int kNoInvokeConstruct = 11;
    public static final int kNoObject = 12;
    public static final int kNoMethod = 13;
    public static final int kNoInvokeMethod = 14;
    public static final int kINoThread = 15;
    public static final int kISleepInt = 16;
    public static final int kITermFail = 17;
    long mErrCode;
    String mErrorString;
    String mJVMString;
    StringTable mTable;

    public JavaError(StringTable pTable) {
        this.mTable = pTable;
    }

    public synchronized void setJavaError(long pErrCode, String pJVMString) {
        this.mErrCode = pErrCode;
        if (this.mTable != null) {
            this.mErrorString = this.mTable.getResourceString(pErrCode);
        }
        this.mJVMString = pJVMString;
    }

    public synchronized void setJavaError(long pErrCode) {
        this.mErrCode = pErrCode;
        if (this.mTable != null) {
            this.mErrorString = this.mTable.getResourceString(pErrCode);
        }
        this.mJVMString = "";
    }

    public long getErrorCode() {
        return this.mErrCode;
    }

    public String getErrorText() {
        return this.mErrorString;
    }

    public String getJVMErrorText() {
        return this.mJVMString;
    }
}

