/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.CoreList;
import JavaCore.CoreObject;
import JavaCore.StringTable;
import JavaCore.ThreadControl;
import JavaCore.ThreadObject;
import JavaCore.ThreadState;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;

public class JavaAPI {
    public static final int kWaiting = 0;
    public static final int kExecuting = 1;
    public static final int kReady = 2;
    public static final int kStopped = 3;
    public static final int kInvalid = 999;
    public static CoreList mList;
    public static StringTable mResourceTable;
    public static final int kChar = 1;
    public static final int kBoolean = 2;
    public static final int kInteger = 3;
    public static final int kDouble = 4;
    public static final int kFloat = 5;
    public static final int kString = 6;
    public static final int kObject = 7;
    public static final int kLong = 8;
    public static final int kByte = 9;
    public static final int kShort = 10;
    public static final int kByteStream = 11;
    public static final int kVector = 12;
    public static final int kDate = 13;
    public static final int kHolder = 15;
    public static Class smCallServiceClass;
    private static String smClassPathProperty;
    private static final String smInEclipseProperty = "omnis.state.ineclipse";
    private static final int[] typemap;
    private static final String[] typearray;
    private static final String[] classTypes;
    private static final String[] classLTypes;
    private static final String[] arrayTypes;
    private static final String[] arrayLTypes;

    public static synchronized ThreadObject getThreadObject(String pThreadID) {
        if (mList == null) {
            mResourceTable = new StringTable();
            mList = new CoreList();
        }
        ThreadObject lthread = mList.findThread(pThreadID);
        return lthread;
    }

    public static synchronized ThreadState getStateObject(String pThreadID) {
        ThreadState lstateObj = null;
        lstateObj = mList.findThreadState(pThreadID);
        return lstateObj;
    }

    public static synchronized String addThread() {
        return mList.addThread();
    }

    public static synchronized CoreObject getCoreObject(String pThreadID) {
        if (mList == null) {
            mResourceTable = new StringTable();
            mList = new CoreList();
        }
        CoreObject lcoreObj = null;
        lcoreObj = mList.findCoreObject(pThreadID);
        return lcoreObj;
    }

    public static String ECOcreateJavaSession(String pThreadID) {
        String retval = "";
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        retval = lcoreObj == null ? JavaAPI.addThread() : pThreadID;
        return retval;
    }

    public static String ECOcreateJavaClass(String pThreadID, String pClassName) {
        return JavaAPI.ECOcreateJavaObject(pThreadID, pClassName, null, null, true);
    }

    public static String ECOcreateJavaClass(String pThreadID, String pClassName, String pClassPath) {
        return JavaAPI.ECOcreateJavaObject(pThreadID, pClassName, pClassPath, null, true);
    }

    public static String ECOcreateJavaObject(String pThreadID, String pClassName, String pClassPath, String pName) {
        return JavaAPI.ECOcreateJavaObject(pThreadID, pClassName, pClassPath, pName, false);
    }

    public static String ECOcreateJavaObject(String pThreadID, String pClassName) {
        return JavaAPI.ECOcreateJavaObject(pThreadID, pClassName, null, null, false);
    }

    public static String ECOcreateJavaObject(String pThreadID, String pClassName, String pClassPath) {
        return JavaAPI.ECOcreateJavaObject(pThreadID, pClassName, pClassPath, null, false);
    }

    public static String ECOcreateJavaObject(String pThreadID, String pClassName, String pClassPath, String pName, boolean pClassOnly) {
        String retval = "";
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        ThreadState lstateObj = null;
        ThreadControl lcontrol = null;
        if (lcoreObj == null) {
            return retval;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        lcontrol = lcoreObj.getThreadController();
        if (lstateObj == null) {
            return retval;
        }
        if (lcontrol == null) {
            return retval;
        }
        if (pName != null) {
            lstateObj.setObjectID(pName);
        } else {
            lstateObj.setObjectID(null);
        }
        lstateObj.setClassFlag(pClassOnly);
        lstateObj.setClassName(pClassName);
        lstateObj.setClassPath(pClassPath);
        lstateObj.setOpCode("createJavaObject");
        lcontrol.executeOpCode();
        return (String)lstateObj.getResult();
    }

    public static String ECOconstructJavaObject(String pThreadID, String pClassID) {
        return JavaAPI.ECOconstructJavaObject(pThreadID, pClassID, null, null, null);
    }

    public static void ECOconstructJavaObject(String pThreadID, String pClassID, String pName) {
        JavaAPI.ECOconstructJavaObject(pThreadID, pClassID, pName, null, null);
    }

    public static String ECOconstructJavaObject(String pThreadID, String pClassID, Class[] pTypes, Object[] pParms) {
        return JavaAPI.ECOconstructJavaObject(pThreadID, pClassID, null, pTypes, pParms);
    }

    public static String ECOconstructJavaObject(String pThreadID, String pClassID, String pName, Class[] pTypes, Object[] pParms) {
        String retval = "";
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        ThreadState lstateObj = null;
        ThreadControl lcontrol = null;
        if (lcoreObj == null) {
            return retval;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        lcontrol = lcoreObj.getThreadController();
        if (lstateObj == null) {
            return retval;
        }
        if (lcontrol == null) {
            return retval;
        }
        if (pName != null) {
            lstateObj.setObjectID(pName);
        } else {
            lstateObj.setObjectID(null);
        }
        lstateObj.setClassID(pClassID);
        lstateObj.setMethodTypes(pTypes);
        lstateObj.setMethodParms(pParms);
        lstateObj.setOpCode("constructJavaObject");
        lcontrol.executeOpCode();
        lstateObj.setObjectReturn(false);
        return (String)lstateObj.getResult();
    }

    public static Object ECOcallJavaMethod(String pThreadID, String pObjectID, String pMethodName) {
        return JavaAPI.ECOcallJavaMethod(pThreadID, pObjectID, pMethodName, null, null);
    }

    public static Object ECOcallJavaMethod(String pThreadID, String pObjectID, String pMethodName, Class[] pTypes, Object[] pParms) {
        return JavaAPI.ECOcallJavaMethod(pThreadID, null, pObjectID, pMethodName, pTypes, pParms);
    }

    public static Object ECOcallStaticJavaMethod(String pThreadID, String pClassID, String pMethodName, Class[] pTypes, Object[] pParms) {
        return JavaAPI.ECOcallJavaMethod(pThreadID, pClassID, null, pMethodName, pTypes, pParms);
    }

    public static Object ECOcallJavaMethod(String pThreadID, String pClassID, String pObjectID, String pMethodName, Class[] pTypes, Object[] pParms) {
        if (pTypes != null) {
            JavaAPI.setScales(pTypes, pParms);
        }
        Object retval = null;
        ThreadState lstateObj = null;
        ThreadControl lctrlObj = null;
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        if (lcoreObj == null) {
            return "";
        }
        lstateObj = lcoreObj.getThreadStateObject();
        lctrlObj = lcoreObj.getThreadController();
        if (lstateObj == null) {
            return "";
        }
        if (lctrlObj == null) {
            return "";
        }
        lstateObj.setMethodName(pMethodName);
        lstateObj.setMethodTypes(pTypes);
        lstateObj.setMethodParms(pParms);
        lstateObj.setClassID(pClassID);
        lstateObj.setObjectID(pObjectID);
        lstateObj.setOpCode("callJavaMethod");
        lctrlObj.executeOpCode();
        lstateObj.setObjectReturn(false);
        retval = lstateObj.getResult();
        return retval;
    }

    private static void setScales(Class[] pTypes, Object[] pParms) {
        int decimalPlace = 14;
        int len = pTypes.length;
        for (int i = 0; i < len; ++i) {
            String name = pTypes[i].getName();
            if (ThreadObject.smThreadLogging) {
                ThreadObject.tconsole.println("class[" + i + "] = " + name);
            }
            if (name.equals("double")) {
                double r = (Double)pParms[i];
                BigDecimal bd = new BigDecimal(r);
                bd = bd.setScale(decimalPlace, 5);
                r = bd.doubleValue();
                if (ThreadObject.smThreadLogging) {
                    ThreadObject.tconsole.println("new Double:" + r);
                }
                pParms[i] = new Double(r);
                continue;
            }
            if (!name.equals("float")) continue;
            float r = ((Float)pParms[i]).floatValue();
            BigDecimal bd = new BigDecimal(r);
            bd = bd.setScale(decimalPlace, 5);
            r = bd.floatValue();
            if (ThreadObject.smThreadLogging) {
                ThreadObject.tconsole.println("new Float:" + r);
            }
            pParms[i] = new Float(r);
        }
    }

    public static void ECOsetObjectReturn(String pThreadID, String pObjectID) {
        ThreadState lstateObj = null;
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        if (lcoreObj == null) {
            return;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        if (lstateObj == null) {
            return;
        }
        lstateObj.setObjectReturn(true);
    }

    public static void ECOdisposeJavaClass(String pThreadID, String pClassID) {
        JavaAPI.ECOdisposeJavaObject(pThreadID, pClassID);
    }

    public static void ECOdisposeJavaObject(String pThreadID, String pObjectID) {
        String lObjectID = pObjectID;
        ThreadState lstateObj = null;
        ThreadControl lctrlObj = null;
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        if (lcoreObj == null) {
            return;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        if (lstateObj == null) {
            return;
        }
        lctrlObj = lcoreObj.getThreadController();
        if (lctrlObj == null) {
            return;
        }
        lstateObj.setObjectID(lObjectID);
        lstateObj.setOpCode("disposeJavaObject");
        lctrlObj.executeOpCode();
    }

    public static Object ECOgetJavaClass(String pThreadID, String pObjectID) {
        return JavaAPI.ECOgetJavaObject(pThreadID, pObjectID, true);
    }

    public static Object ECOgetJavaObject(String pThreadID, String pObjectID) {
        return JavaAPI.ECOgetJavaObject(pThreadID, pObjectID, false);
    }

    public static Object ECOgetJavaObject(String pThreadID, String pObjectID, boolean pIsClass) {
        Object retval = null;
        String lObjectID = pObjectID;
        ThreadState lstateObj = null;
        ThreadControl lctrlObj = null;
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        if (lcoreObj == null) {
            return retval;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        if (lstateObj == null) {
            return retval;
        }
        lctrlObj = lcoreObj.getThreadController();
        if (lctrlObj == null) {
            return retval;
        }
        lstateObj.setObjectID(lObjectID);
        if (pIsClass) {
            lstateObj.setOpCode("getJavaClass");
        } else {
            lstateObj.setOpCode("getJavaObject");
        }
        lctrlObj.executeOpCode();
        retval = lstateObj.getResult();
        lstateObj.setResult(null);
        return retval;
    }

    public static synchronized void ECOdisposeJavaSession(String pThreadID) {
        if (mList != null) {
            mList.removeThread(pThreadID);
        }
        System.gc();
    }

    public static long ECOgetLastJavaError(String pThreadID) {
        Long lobj = null;
        long retval = 0L;
        lobj = (Long)JavaAPI.ECOgetLastJavaErr(pThreadID, 1L);
        retval = lobj;
        return retval;
    }

    public static String ECOgetLastJavaErrorText(String pThreadID) {
        return (String)JavaAPI.ECOgetLastJavaErr(pThreadID, 2L);
    }

    public static String ECOgetLastJVMErrorText(String pThreadID) {
        return (String)JavaAPI.ECOgetLastJavaErr(pThreadID, 3L);
    }

    public static Object ECOgetLastJavaErr(String pThreadID, long pInfo) {
        int kNoThreadID = 1;
        int kINoState = 2;
        Object retval = null;
        ThreadState lstateObj = null;
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        if (lcoreObj == null) {
            retval = JavaAPI.getJError(kNoThreadID, pInfo);
            return retval;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        if (lstateObj == null) {
            retval = JavaAPI.getJError(kINoState, pInfo);
            return retval;
        }
        retval = pInfo == 1L ? new Long(lstateObj.getJavaError()) : (pInfo == 2L ? lstateObj.getJavaErrorText() : lstateObj.getJavaJVMText());
        return retval;
    }

    public static Object ECOcreateObjectsFromList(String pThreadID, Object[] pArray) {
        Object retval = null;
        ThreadState lstateObj = null;
        ThreadControl lctrlObj = null;
        CoreObject lcoreObj = JavaAPI.getCoreObject(pThreadID);
        if (lcoreObj == null) {
            return null;
        }
        lstateObj = lcoreObj.getThreadStateObject();
        if (lstateObj == null) {
            return retval;
        }
        lctrlObj = lcoreObj.getThreadController();
        if (lctrlObj == null) {
            return retval;
        }
        lstateObj.setDataArray(pArray);
        lstateObj.setOpCode("createObjectsFromList");
        lctrlObj.executeOpCode();
        retval = lstateObj.getResult();
        return retval;
    }

    public static int ECOisClassPrimitive(Object pObject) {
        int lresult = 1;
        Class<?> lclass = null;
        String cname = null;
        lclass = pObject.getClass();
        cname = lclass.toString();
        if (cname.indexOf(".") > 0) {
            lresult = 0;
        }
        return lresult;
    }

    public static int ECOisPrimitive(Object pObject) {
        int[] retval = JavaAPI.getObjectType(pObject);
        return retval[1];
    }

    public static String ECOgetArrayContents(Object pObject) {
        StringBuilder buffer;
        block43: {
            int[] retval;
            String delim;
            block42: {
                delim = "<%omjdelim%>";
                buffer = new StringBuilder();
                retval = JavaAPI.getObjectType(pObject);
                if (retval[2] != 1 || retval[1] != 1) break block42;
                switch (retval[0]) {
                    case 1: {
                        char[] arr = (char[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 2: {
                        boolean[] arr = (boolean[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 3: {
                        int[] arr = (int[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 4: {
                        double[] arr = (double[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 5: {
                        float[] arr = (float[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 8: {
                        long[] arr = (long[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 9: {
                        byte[] arr = (byte[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                    case 10: {
                        short[] arr = (short[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break block43;
                    }
                }
                break block43;
            }
            if (retval[2] == 1 && retval[1] == 0) {
                switch (retval[0]) {
                    case 1: {
                        Character[] arr = (Character[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i].charValue());
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 2: {
                        Boolean[] arr = (Boolean[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 3: {
                        Integer[] arr = (Integer[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 4: {
                        Double[] arr = (Double[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 5: {
                        Float[] arr = (Float[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i].floatValue());
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 8: {
                        Long[] arr = (Long[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i]);
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 9: {
                        Byte[] arr = (Byte[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i].byteValue());
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 10: {
                        Short[] arr = (Short[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i].shortValue());
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 6: {
                        String[] arr = (String[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            buffer.append(arr[i].toString());
                            buffer.append(delim);
                        }
                        break;
                    }
                    case 13: {
                        Date[] arr = (Date[])pObject;
                        for (int i = 0; i < arr.length; ++i) {
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTime(arr[i]);
                            String monthStr = null;
                            int month = calendar.get(2) + 1;
                            monthStr = month < 10 ? "0" + month : "" + month;
                            String dayStr = null;
                            int day = calendar.get(5);
                            dayStr = day < 10 ? "0" + day : "" + day;
                            String hourStr = null;
                            int hour = calendar.get(11);
                            hourStr = hour < 10 ? "0" + hour : "" + hour;
                            String minuteStr = null;
                            int minute = calendar.get(12);
                            minuteStr = minute < 10 ? "0" + minute : "" + minute;
                            String secondStr = null;
                            int second = calendar.get(13);
                            secondStr = second < 10 ? "0" + second : "" + second;
                            String millisecondStr = null;
                            int millisecond = calendar.get(14);
                            if (millisecond < 10) {
                                millisecondStr = "00" + millisecond;
                            }
                            millisecondStr = millisecond < 100 ? "0" + millisecond : "" + millisecond;
                            buffer.append(calendar.get(1));
                            buffer.append('-');
                            buffer.append(monthStr);
                            buffer.append('-');
                            buffer.append(dayStr);
                            buffer.append(' ');
                            buffer.append(hourStr);
                            buffer.append(':');
                            buffer.append(minuteStr);
                            buffer.append(':');
                            buffer.append(secondStr);
                            buffer.append('.');
                            buffer.append(millisecondStr);
                            buffer.append(delim);
                        }
                        break;
                    }
                }
            }
        }
        return buffer.toString();
    }

    public static int ECOisArray(Object pObject) {
        int[] retval = JavaAPI.getObjectType(pObject);
        return retval[2];
    }

    public static int ECOgetObjectType(Object pObject) {
        int[] retval = JavaAPI.getObjectType(pObject);
        return retval[0];
    }

    public static Object getHolderValue(Object pHolderObject) {
        Object lRetObject = null;
        Field lHolderValue = null;
        Class<?> lHolderClass = pHolderObject.getClass();
        try {
            lHolderValue = lHolderClass.getDeclaredField("value");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            if (lHolderValue != null) {
                lRetObject = lHolderValue.get(pHolderObject);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return lRetObject;
    }

    public static String ECOgetClassName(Object pObject) {
        Class<?> lclass = pObject.getClass();
        String lstr = lclass.toString();
        return lstr;
    }

    private static int[] getObjectType(Object pObject) {
        int[] retval = new int[3];
        if (pObject == null) {
            return retval;
        }
        boolean lresult = false;
        String lstr = String.valueOf(pObject.getClass());
        for (int i = 0; i < typearray.length; ++i) {
            String ltmp = classTypes[i];
            String ltmp1 = classLTypes[i];
            if (lstr.compareTo(ltmp) != 0 && lstr.compareTo(ltmp1) != 0) continue;
            retval[0] = typemap[i];
            if (lstr.compareTo(ltmp1) == 0) {
                if (ltmp1.indexOf("L") < 0) {
                    retval[1] = 1;
                }
            } else if (ltmp.indexOf("L") < 0) {
                retval[1] = 1;
            }
            if (retval[0] != 12) break;
            lresult = true;
            retval[1] = 0;
            retval[2] = 1;
            break;
        }
        if (!lresult) {
            String isHolder;
            boolean matched = false;
            for (int i = 0; i < typearray.length; ++i) {
                String ltmp = arrayTypes[i];
                String ltmp1 = arrayLTypes[i];
                if (lstr.compareTo(ltmp) != 0 && lstr.compareTo(ltmp1) != 0) continue;
                matched = true;
                retval[0] = typemap[i];
                if (lstr.compareTo(ltmp1) == 0) {
                    if (ltmp1.indexOf("L") < 0) {
                        retval[1] = 1;
                    }
                    if (ltmp1.indexOf("[") < 0) break;
                    retval[2] = 1;
                    break;
                }
                if (ltmp.indexOf("L") < 0) {
                    retval[1] = 1;
                }
                if (ltmp.indexOf("[") < 0) break;
                retval[2] = 1;
                break;
            }
            if (lstr.length() > 27 && (isHolder = lstr.substring(0, 27)).compareTo("class javax.xml.rpc.holders") == 0) {
                matched = true;
                retval[0] = 15;
                retval[1] = 0;
                retval[2] = 0;
            }
            if (!matched && lstr.indexOf("[") >= 0) {
                retval[2] = 1;
            }
        }
        return retval;
    }

    public static Date[] ECOcreateDateArray(int pArrayLength) {
        Date[] retval = new Date[pArrayLength];
        return retval;
    }

    public static String ECOconvertCharToString(Object p1, int pLength) {
        int i = 0;
        String retval = null;
        if (p1 == null) {
            return retval;
        }
        Character[] c1 = (Character[])p1;
        if (c1[0] == null) {
            return retval;
        }
        retval = c1[0].toString();
        if (pLength > 1) {
            for (i = 1; i < pLength; ++i) {
                retval = retval + c1[i].toString();
            }
        }
        return retval;
    }

    public static String ECOconvertCharToString(Object p1) {
        String retval = null;
        if (p1 == null) {
            return retval;
        }
        char[] c1 = (char[])p1;
        retval = new String(c1);
        return retval;
    }

    public static Object ECOconvertStringToCharacter(Object p1, int isPrimitive) {
        String s1 = (String)p1;
        Object[] o1 = null;
        if (isPrimitive == 1) {
            char[] c1;
            o1 = c1 = s1.toCharArray();
        } else {
            int clen = s1.length();
            int i = 0;
            char[] pc1 = s1.toCharArray();
            Character[] c1 = new Character[clen];
            for (i = 0; i < clen; ++i) {
                c1[i] = new Character(pc1[i]);
                o1 = c1;
            }
        }
        return o1;
    }

    public static void ECOsetOmnisEclipseClassPath(String pOmnisClassPath) {
        smClassPathProperty = "omnis.class.path";
        System.setProperty(smClassPathProperty, pOmnisClassPath);
        System.setProperty(smInEclipseProperty, "1");
    }

    public static String ECOgetClassPathProperty() {
        return smClassPathProperty;
    }

    public static boolean getInEclipse() {
        return System.getProperty(smInEclipseProperty).equals("1");
    }

    public static Object ECOgetCallServiceObject() {
        if (JavaAPI.getInEclipse()) {
            try {
                return smCallServiceClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Object getJError(long pID, long pInfo) {
        Object retval = null;
        long errcode = 0L;
        String errtext = "";
        if (pInfo == 1L) {
            errcode = pID;
            retval = new Long(errcode);
        } else if (pInfo == 2L) {
            errtext = mResourceTable.getResourceString(pID);
            retval = errtext;
        }
        return retval;
    }

    static {
        smCallServiceClass = null;
        smClassPathProperty = "java.class.path";
        System.setProperty(smInEclipseProperty, "0");
        typemap = new int[]{3, 3, 8, 8, 10, 10, 2, 2, 5, 5, 4, 4, 9, 9, 1, 1, 6, 7, 12, 13};
        typearray = new String[]{"java.lang.Integer", "I", "java.lang.Long", "J", "java.lang.Short", "S", "java.lang.Boolean", "Z", "java.lang.Float", "F", "java.lang.Double", "D", "java.lang.Byte", "B", "java.lang.Character", "C", "java.lang.String", "java.lang.Object", "java.util.Vector", "java.util.Date"};
        classTypes = new String[typearray.length];
        classLTypes = new String[typearray.length];
        arrayTypes = new String[typearray.length];
        arrayLTypes = new String[typearray.length];
        for (int i = 0; i < typearray.length; ++i) {
            JavaAPI.classTypes[i] = "class " + typearray[i];
            JavaAPI.classLTypes[i] = "class L" + typearray[i] + ";";
            JavaAPI.arrayTypes[i] = "class [" + typearray[i];
            JavaAPI.arrayLTypes[i] = "class [L" + typearray[i] + ";";
        }
    }
}

