/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.JarClassLoader;
import java.util.HashMap;

public class JarManager {
    private final HashMap<String, JarClassLoader> mapLoaders = new HashMap();

    public JarClassLoader getInstance(String jarName, ClassLoader pParent) {
        JarClassLoader loader = this.mapLoaders.get(jarName);
        if (loader == null) {
            loader = this.newInstance(jarName, pParent);
        } else if (!loader.isUpToDate()) {
            this.mapLoaders.remove(jarName);
            loader = this.newInstance(jarName, pParent);
        }
        return loader;
    }

    public void unloadAll() {
        this.mapLoaders.clear();
    }

    private JarClassLoader newInstance(String jarName, ClassLoader parent) {
        JarClassLoader loader = JarClassLoader.newInstance(jarName, parent);
        if (loader != null) {
            this.mapLoaders.put(jarName, loader);
        }
        return loader;
    }
}

