/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.JarResources;
import JavaCore.MultiClassLoader;
import java.io.File;

public class JarClassLoader
extends MultiClassLoader {
    private JarResources jarResources;
    private File jarFile;

    public JarClassLoader(String jarName, ClassLoader pParent) {
        super(pParent);
        this.jarFile = new File(jarName);
        this.jarResources = new JarResources(this.jarFile);
    }

    public String getJarPath() {
        return this.jarResources.getJarPath();
    }

    protected boolean isUpToDate() {
        File currJar = new File(this.jarFile.getAbsolutePath());
        if (currJar.exists()) {
            return currJar.lastModified() <= this.jarFile.lastModified();
        }
        return false;
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        return this.jarResources.getResource(className);
    }

    public static JarClassLoader newInstance(String jarName, ClassLoader pParent) {
        JarClassLoader loader = null;
        File jarFile = new File(jarName);
        if (jarFile.exists()) {
            loader = new JarClassLoader(jarName, pParent);
        }
        return loader;
    }
}

