/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.MultiClassLoader;
import java.io.File;
import java.io.FileInputStream;

public class FileClassLoader
extends MultiClassLoader {
    private String filePrefix;

    public FileClassLoader(String filePrefix, ClassLoader pParent) {
        super(pParent);
        this.filePrefix = filePrefix != null && !filePrefix.endsWith(File.separator) && !filePrefix.endsWith("/") ? filePrefix + File.separator : filePrefix;
    }

    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        if (this.sourceMonitorOn) {
            FileClassLoader.print(">> from file: " + className);
        }
        String fileName = this.filePrefix + className;
        try {
            FileInputStream inStream = new FileInputStream(fileName);
            byte[] result = new byte[inStream.available()];
            inStream.read(result);
            inStream.close();
            return result;
        }
        catch (Exception e) {
            FileClassLoader.print("### File '" + fileName + "' not found.");
            return null;
        }
    }
}

