/*
 * Decompiled with CFR 0.152.
 */
package JavaCore;

import JavaCore.ThreadControl;
import JavaCore.ThreadObject;
import JavaCore.ThreadState;

public class CoreObject {
    String mID;
    String mType;
    ThreadObject mThreadObject;
    ThreadState mThreadState;
    ThreadControl mControl;
    Object mClassObject;
    Class mClass;
    boolean mWaiting;
    public static final int kWaiting = 0;
    public static final int kExecuting = 1;
    public static final int kReady = 2;
    public static final int kStopped = 3;
    public static final int kInvalid = 999;

    CoreObject(String pTypeID) {
        if (pTypeID.equals("Thread")) {
            this.mType = "Thread";
            this.mWaiting = false;
            this.mThreadState = new ThreadState();
            this.mThreadObject = new ThreadObject(this.mThreadState, this);
            this.mControl = new ThreadControl(this.mThreadObject, this.mThreadState, this);
            this.mThreadObject.setController(this.mControl);
            this.mThreadObject.start();
            this.mID = this.mThreadObject.getThreadID();
            this.mClassObject = null;
            this.mClass = null;
        }
    }

    CoreObject(Object pObject) {
        this.mType = "Object";
        this.mClassObject = pObject;
        this.mClass = this.mClassObject.getClass();
        this.mID = "obj" + this;
        this.mThreadObject = null;
        this.mThreadState = null;
        this.mControl = null;
    }

    CoreObject(Class pClass) {
        this.mType = "Class";
        this.mClassObject = null;
        this.mClass = pClass;
        this.mID = this.mClass.getName();
        this.mThreadObject = null;
        this.mThreadState = null;
        this.mControl = null;
    }

    public synchronized void waitForOther() {
        if (!this.mWaiting) {
            this.mWaiting = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.mWaiting = false;
            this.notify();
        }
    }

    public ThreadState getThreadStateObject() {
        return this.mThreadState;
    }

    public int getThreadState() {
        return this.mThreadState.getThreadState();
    }

    public void setThreadState(int pThreadState) {
        this.mThreadState.setThreadState(pThreadState);
    }

    public Object getObject() {
        return this.mClassObject;
    }

    public Class getCoreClass() {
        return this.mClass;
    }

    public ThreadObject getThreadObject() {
        return this.mThreadObject;
    }

    public ThreadControl getThreadController() {
        return this.mControl;
    }

    public String getObjectID() {
        return this.mID;
    }

    public void setObjectID(String pID) {
        this.mID = pID;
    }

    public String getClassID() {
        return this.mID;
    }

    public void setClassID(String pID) {
        this.mID = pID;
    }

    public String getThreadID() {
        return this.mID;
    }

    public String getObjectType() {
        return this.mType;
    }

    public void disposeObject() {
        if (this.mType.equals("Thread")) {
            this.mControl.terminateThread();
            this.mThreadObject = null;
            this.mThreadState = null;
            this.mControl = null;
        } else if (this.mType.equals("Object")) {
            this.mClassObject = null;
            if (this.mClass != null) {
                this.mClass = null;
            }
        } else if (this.mType.equals("Class")) {
            this.mClass = null;
        }
    }
}

